package com.liquidnet.service.dragon.channel.alipay.biz;

import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.request.AlipayTradeAppPayRequest;
import com.alipay.api.request.AlipayTradeQueryRequest;
import com.alipay.api.request.AlipayTradeWapPayRequest;
import com.alipay.api.response.AlipayTradeAppPayResponse;
import com.alipay.api.response.AlipayTradeQueryResponse;
import com.alipay.api.response.AlipayTradeWapPayResponse;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.dragon.channel.alipay.req.AlipayTradePayReq;
import com.liquidnet.service.dragon.channel.alipay.sign.MD5;
import com.liquidnet.service.dragon.constant.DragonConstant;
import com.liquidnet.service.dragon.dto.DragonPayBaseReqDto;
import com.liquidnet.service.dragon.dto.DragonPayBaseRespDto;
import com.liquidnet.service.dragon.entity.DragonOrders;
import com.liquidnet.service.dragon.utils.MqHandleUtil;
import com.liquidnet.service.dragon.utils.PayAlipayUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.*;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: AlipayBiz
 * @Package com.liquidnet.service.dragon.channel.alipay.biz
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/7/10 16:21
 */
@Slf4j
@Component
public class AlipayBiz {
    @Autowired
    private MqHandleUtil mqHandleUtil;

    public DragonOrders buildPayOrders(DragonPayBaseReqDto dragonPayBaseReqDto, DragonPayBaseRespDto respDto){
        DragonOrders orders = new DragonOrders();
//        orders.setMid();
        orders.setStatus(Integer.valueOf(DragonConstant.PayStatusEnum.STATUS_UNPAID.getCode()));
        orders.setCode(respDto.getCode());
        orders.setType(dragonPayBaseReqDto.getType());
        orders.setPrice(dragonPayBaseReqDto.getPrice());
        orders.setName(dragonPayBaseReqDto.getName());
        orders.setDetail(dragonPayBaseReqDto.getDetail());
        orders.setOrderCode(dragonPayBaseReqDto.getOrderCode());
        orders.setClientIp(dragonPayBaseReqDto.getClientIp());
        orders.setNotifyUrl(dragonPayBaseReqDto.getNotifyUrl());
        orders.setPaymentType(DragonConstant.PayTypeEnum.PAYMENT_TYPE_APP_IAP.getCode());
//        orders.setPaymentId();
        orders.setPaymentAt(LocalDateTime.now());
//        orders.setFinishedAt();
        orders.setCreatedAt(LocalDateTime.now());
//        orders.setUpdatedAt();
        // 修改退款订单
        boolean insertResult = mqHandleUtil.sendMySqlRedis(
                SqlMapping.get("dragon_orders.insert"),
                new Object[]{orders.getStatus(), orders.getCode(), orders.getType()
                        , orders.getPrice(), orders.getName(), orders.getDetail()
                        , orders.getOrderCode(), orders.getClientIp()
                        , orders.getNotifyUrl(), orders.getPaymentType(),
                        orders.getPaymentId(), orders.getPaymentAt()
                        , orders.getFinishedAt(), orders.getCreatedAt()
                        , orders.getUpdatedAt()}
        );
        return orders;
    }

    /**
     * 支付宝支付
     * @param alipayTradePayReq
     * @return
     */
    public static Map<String, Object> tradeWapPay(AlipayTradePayReq alipayTradePayReq) {
        log.info("AlipayUtil.tradeWapPay-->> req : {}",alipayTradePayReq.toString());
        String timeExpress = "5m";// 支付超时，线下扫码交易定义为5分钟

        AlipayClient alipayClient = PayAlipayUtils.getInstance().getHttpClient();

        SortedMap<String, Object> paramMap = new TreeMap<>();
        paramMap.put("product_code", alipayTradePayReq.getProductCode());
        paramMap.put("total_amount", alipayTradePayReq.getTotalAmount().toString());
        paramMap.put("subject", alipayTradePayReq.getSubject());
        paramMap.put("body", alipayTradePayReq.getBody());
        paramMap.put("out_trade_no", alipayTradePayReq.getOutTradeNo());
        paramMap.put("timeout_express", timeExpress);


        AlipayTradeWapPayRequest request = new AlipayTradeWapPayRequest();
        request.setNotifyUrl(alipayTradePayReq.getNotifyUrl());
//        request.setTimestamp(DateUtil.now());
        log.info("bizContent :{}", JSONObject.toJSONString(paramMap));
        request.setBizContent(JSONObject.toJSONString(paramMap));
        try {
            AlipayTradeWapPayResponse response = alipayClient.sdkExecute(request);
            JSONObject responseJSON = JSONObject.parseObject(JSONObject.toJSONString(response));
            log.info("AlipayUtil-->tradeWapPay-->支付宝返回结果:{}", responseJSON);
            return responseJSON;
        } catch (AlipayApiException e) {
            log.error("支付宝支付异常:{}", e);
            JSONObject resultJSON = new JSONObject();
            resultJSON.put("outTradeNo", alipayTradePayReq.getOutTradeNo());
            resultJSON.put("totalAmount", alipayTradePayReq.getTotalAmount().toString());
            resultJSON.put("errorCode", "9999");
            return resultJSON;
        }
    }

    /**
     * 支付宝支付
     * @param alipayTradePayReq
     * @return
     */
    public static Map<String, Object> tradeAppPay(AlipayTradePayReq alipayTradePayReq) {
        log.info("AlipayUtil.tradeAppPay-->> req : {}",alipayTradePayReq.toString());
        String timeExpress = "5m";// 支付超时，线下扫码交易定义为5分钟

        AlipayClient alipayClient = PayAlipayUtils.getInstance().getHttpClient();

        SortedMap<String, Object> paramMap = new TreeMap<>();
        paramMap.put("product_code", alipayTradePayReq.getProductCode());
        paramMap.put("total_amount", alipayTradePayReq.getTotalAmount().toString());
        paramMap.put("subject", alipayTradePayReq.getSubject());
        paramMap.put("body", alipayTradePayReq.getBody());
        paramMap.put("out_trade_no", alipayTradePayReq.getOutTradeNo());
        paramMap.put("timeout_express", timeExpress);


        AlipayTradeAppPayRequest request = new AlipayTradeAppPayRequest();
        request.setNotifyUrl(alipayTradePayReq.getNotifyUrl());
//        request.setTimestamp(DateUtil.now());
        log.info("bizContent :{}",JSONObject.toJSONString(paramMap));
        request.setBizContent(JSONObject.toJSONString(paramMap));
        try {
            AlipayTradeAppPayResponse response = alipayClient.sdkExecute(request);
            JSONObject responseJSON = JSONObject.parseObject(JSONObject.toJSONString(response));
            log.info("AlipayUtil-->tradeAppPay-->支付宝返回结果:{}", responseJSON);
            return responseJSON;
        } catch (AlipayApiException e) {
            log.error("支付宝支付异常:{}", e);
            JSONObject resultJSON = new JSONObject();
            resultJSON.put("outTradeNo", alipayTradePayReq.getOutTradeNo());
            resultJSON.put("totalAmount", alipayTradePayReq.getTotalAmount().toString());
            resultJSON.put("errorCode", "9999");
            return resultJSON;
        }
    }


    /**
     * 订单查询
     *
     * @return
     */
    public static Map<String, Object> tradeQuery(String outTradeNo) {
        log.info("======>支付宝交易查询");
        String charset = "UTF-8";
        String format = "json";
        String signType = "RSA2";
        AlipayClient alipayClient = PayAlipayUtils.getInstance().getHttpClient();

        SortedMap<String, Object> bizContentMap = new TreeMap<>();
        bizContentMap.put("out_trade_no", outTradeNo);
        AlipayTradeQueryRequest request = new AlipayTradeQueryRequest();
        request.setBizContent(JSONObject.toJSONString(bizContentMap));
        try {
            AlipayTradeQueryResponse response = alipayClient.execute(request);
            JSONObject responseJSON = JSONObject.parseObject(JSONObject.toJSONString(response));
            log.info("支付宝订单查询返回结果:{}", responseJSON);
            return responseJSON;
        } catch (AlipayApiException e) {
            log.error("支付宝交易查询异常:{}", e);
            return null;
        }
    }

    private static String getSign(SortedMap<String, String> paramMap, String key) {
        StringBuilder signBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : paramMap.entrySet()) {
            if (!"sign".equals(entry.getKey()) && !"sign_type".equals(entry.getKey()) && !StringUtil.isEmpty(entry.getValue())) {
                signBuilder.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
            }
        }
        return MD5.sign(signBuilder.substring(0, signBuilder.length() - 1), key, "UTF-8");
    }

    public static Map<String , String> parseNotifyMsg(Map<String, String[]> requestParams){

        Map<String,String> params = new HashMap<String,String>();

        for (Iterator iter = requestParams.keySet().iterator(); iter.hasNext();) {
            String name = (String) iter.next();
            String[] values = requestParams.get(name);
            String valueStr = "";
            for (int i = 0; i < values.length; i++) {
                valueStr = (i == values.length - 1) ? valueStr + values[i]
                        : valueStr + values[i] + ",";
            }
            params.put(name, valueStr);
        }

        return params;
    }
}
