package com.liquidnet.service.platform.service.impl.candy;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.OrderCloseMapping;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.candy.dto.CandyUserCouponBasicDto;
import com.liquidnet.service.candy.entity.CandyUserCoupon;
import com.liquidnet.service.candy.mapper.CandyUserCouponMapper;
import com.liquidnet.service.kylin.entity.KylinOrderTickets;
import com.liquidnet.service.platform.utils.QueueUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

@Service
public class PlatformCandyUserCouponService extends ServiceImpl<CandyUserCouponMapper, CandyUserCoupon> {

    @Autowired
    private PlatformCandyUserCouponService platformCandyUserCouponService;
    @Autowired
    private QueueUtils queueUtils;

    /**
     * @param uCouponUidList 内容 uCouponId,uid List
     * @param uCouponIdList  内容 uCouponId List
     * @return
     */
    public Boolean useBackCoupon(ArrayList<String> uCouponUidList, ArrayList<String> uCouponIdList) {
        //修改数据库
        CandyUserCoupon userCoupon = CandyUserCoupon.getNew();
        userCoupon.setState(1);
        platformCandyUserCouponService.update(userCoupon, new UpdateWrapper<CandyUserCoupon>().in("ucoupon_id", uCouponIdList));
        //sendRedis
        int forSize = 500;
        int forCount = uCouponUidList.size() % forSize == 0 ? uCouponUidList.size() / forSize : (uCouponUidList.size() / forSize) + 1;
        for (int i = 0; i < forCount; i++) {
            LinkedList<String> mqList = new LinkedList<>();
            for (int y = 0; y < forSize; y++) {
                try {
                    String t = uCouponUidList.get(i * 500 + y);
                    mqList.add(t);
                } catch (Exception e) {
                    break;
                }
            }
            queueUtils.sendMsgByRedis(MQConst.CandyQueue.COUPON_ORDER_BACK.getKey(), OrderCloseMapping.get(mqList));
        }
        return true;
    }
}
