package com.liquidnet.service.sweet.handler;

import com.liquidnet.common.third.shumei.util.ShumeiUtil;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.sweet.config.WechatMaConfigure;
import com.liquidnet.service.sweet.utils.QueueUtils;
import com.liquidnet.service.sweet.utils.WechatUsersRedisUtils;
import com.liquidnet.service.sweet.vo.SweetMaoDengVo;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.mp.api.WxMpMessageHandler;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.kefu.WxMpKefuMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutTextMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.LinkedList;
import java.util.Map;

/**
 * <p>
 * 文本消息
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-11-25
 */
@Component
@Slf4j
public class TextMsgHandler implements WxMpMessageHandler {

    @Autowired
    private WechatUsersRedisUtils redisUtils;
    @Autowired
    WechatMaConfigure maConfigure;
    @Autowired
    private ShumeiUtil shumeiUtil;
    @Autowired
    QueueUtils queueUtils;

    @Override
    public WxMpXmlOutMessage handle(WxMpXmlMessage wxMessage, Map<String, Object> context, WxMpService wxMpService,
                                    WxSessionManager sessionManager) throws WxErrorException {
        String maoContent = wxMessage.getContent();//获取文字消息
        String fromUser = wxMessage.getFromUser();//用户id
        SweetMaoDengVo sweetMaoDengVo = SweetMaoDengVo.getNew();
        sweetMaoDengVo.setUserId(fromUser);
        sweetMaoDengVo.setTextMsg(maoContent);
        //敏感词判断
        //此处判断不需要用户登录，所以使用时间代替
        String currentUid = DateUtil.now().getTime() + "";
        if (!shumeiUtil.checkText(currentUid, maoContent)) {
            //文字敏感 提示，发送文本消息
            WxMpXmlOutTextMessage build = WxMpXmlOutMessage.TEXT().content("无法识别，TA是不是还有别的名字呢！（请勿使用表情等特殊字符）")
                    .fromUser(wxMessage.getToUser()).toUser(wxMessage.getFromUser())
                    .build();
            return null;
        }
        if (maoContent.equals("猫登天空")) {
            redisUtils.setSweetMaoDengOpen(fromUser, 10 * 60);
            WxMpXmlOutTextMessage build = WxMpXmlOutMessage.TEXT().content("欢迎关注猫登天空！请输入你的猫猫的名字，并发送一张你的猫猫的照片给服务号。")
                    .fromUser(wxMessage.getToUser()).toUser(wxMessage.getFromUser())
                    .build();
            return null;
        }
        String i = redisUtils.getSweetMaoDengOpen(fromUser);
        //是否参加了活动
        if (StringUtil.isNotEmpty(i)) {

            SweetMaoDengVo sweetMaoDeng = redisUtils.getSweetMaoDeng(fromUser);
            //是否上传了图
            if (sweetMaoDeng != null) {

                String picUrl = sweetMaoDeng.getPicUrl();
                sweetMaoDengVo.setPicUrl(picUrl);

                //更新mysql
                LinkedList<String> sqls = CollectionUtil.linkedListString();
                LinkedList<Object[]> sqlsDataA = CollectionUtil.linkedListObjectArr();
                sqls.add(SqlMapping.get("sweet_wechat_maodeng.text.update"));
                sqlsDataA.add(new Object[]{fromUser, maoContent});
                queueUtils.sendMsgByRedis(MQConst.SweetQueue.SWEET_WECHAT_MAODENG_TEXT_INSERT.getKey(), SqlMapping.gets(sqls, sqlsDataA));
            } else {
                //redis队列入库
                String maoId = IDGenerator.nextSnowId();
                LinkedList<String> sqls = CollectionUtil.linkedListString();
                LinkedList<Object[]> sqlsDataA = CollectionUtil.linkedListObjectArr();
                sqls.add(SqlMapping.get("sweet_wechat_maodeng.insert"));
                sqlsDataA.add(new Object[]{maoId, fromUser, maoContent, null});
                queueUtils.sendMsgByRedis(MQConst.SweetQueue.SWEET_WECHAT_MAODENG_TEXT_INSERT.getKey(), SqlMapping.gets(sqls, sqlsDataA));
            }
            redisUtils.setSweetMaoDeng(sweetMaoDengVo);
        }



//--------------------------------------------------------------------------------------------------------------------------
        boolean IsPosterClick = redisUtils.getStrawberryPosterClick(wxMessage.getFromUser());
        if (IsPosterClick) {
            String content = wxMessage.getContent();
            // 发送文本消息
            WxMpXmlOutTextMessage build = WxMpXmlOutMessage.TEXT().content("您已参与活动，输入的姓名为:".concat(content).concat(" 请点击下方小程序参加活动"))
                    .fromUser(wxMessage.getToUser()).toUser(wxMessage.getFromUser())
                    .build();
            // 发送活动小程序卡片
            WxMpKefuMessage message = WxMpKefuMessage.MINIPROGRAMPAGE()
                    .appId(maConfigure.getWxMaAppid(4))
                    .pagePath("/pages/index?nickname=".concat(content))
                    .thumbMediaId("ov08q51In7bXX6tXv7FewxFNN0G78n-pPRsbi3LZbPE")
                    .title("正在摩登")
                    .toUser(wxMessage.getFromUser())
                    .build();
            wxMpService.getKefuService().sendKefuMessage(message);
            return build;
        } else {
            // 正常消息不处理
            return null;
        }


    }
}
