package com.liquidnet.service.goblin.dto.manage.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@ApiModel(value = "GoblinMgtCategorySpecVo", description = "分类关联的规格信息")
@Data
public class GoblinMgtCategorySpecVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -1807588898644126000L;
    @ApiModelProperty(position = 11, value = "分类ID")
    private String cateId;
    @ApiModelProperty(position = 13, value = "规格名称List")
    private List<String> specNameList;

    public GoblinMgtCategorySpecVo setCateId(String cateId) {
        this.cateId = cateId;
        return this;
    }

    public GoblinMgtCategorySpecVo setSpecNameList(List<String> specNameList) {
        this.specNameList = specNameList;
        return this;
    }

    private static final GoblinMgtCategorySpecVo obj = new GoblinMgtCategorySpecVo();
    public static GoblinMgtCategorySpecVo getNew() {
        try {
            return (GoblinMgtCategorySpecVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinMgtCategorySpecVo();
        }
    }
}
