package com.liquidnet.service.consumer.kylin.config;

import com.liquidnet.common.cache.redis.config.RedisStreamConfig;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.consumer.kylin.receiver.ConsumerGoblinBizArtworkClqRdsReceiver;
import com.liquidnet.service.consumer.kylin.receiver.ConsumerGoblinBizArtworkUplRdsReceiver;
import com.liquidnet.service.consumer.kylin.receiver.ConsumerGoblinBizIntegralReceiver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

import java.util.ArrayList;
import java.util.List;

@Configuration
public class ConsumerCommonBizRedisStreamConfig extends RedisStreamConfig {
    @Autowired
    StringRedisTemplate stringRedisTemplate;
    @Autowired
    ConsumerGoblinBizArtworkUplRdsReceiver consumerGoblinBizArtworkUplRdsReceiver;
    @Autowired
    ConsumerGoblinBizArtworkClqRdsReceiver consumerGoblinBizArtworkClqRdsReceiver;
//    @Autowired
//    ConsumerGoblinBizArtworkGenRdsReceiver consumerGoblinBizArtworkGenRdsReceiver;
    @Autowired
    ConsumerGoblinBizIntegralReceiver consumerGoblinBizIntegralReceiver;

    @Bean// 藏品上传声明
    public List<Subscription> subscriptionBizArtworkUpl(RedisConnectionFactory factory) {
        List<Subscription> subscriptionList = new ArrayList<>();
        MQConst.GoblinQueue stream = MQConst.GoblinQueue.BIZ_ARTWORK_UPL;
        this.initStream(stringRedisTemplate, stream.getKey(), stream.getGroup());
        for (int i = 0; i < 2; i++) {
            StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer = this.buildStreamMessageListenerContainer(factory);
            subscriptionList.add(listenerContainer.receiveAutoAck(
                    Consumer.from(stream.getGroup(), getConsumerName(stream.name() + i)),
                    StreamOffset.create(stream.getKey(), ReadOffset.lastConsumed()), consumerGoblinBizArtworkUplRdsReceiver
            ));
            listenerContainer.start();
        }
        return subscriptionList;
    }

    @Bean// 藏品声明查询
    public List<Subscription> subscriptionBizArtworkClq(RedisConnectionFactory factory) {
        List<Subscription> subscriptionList = new ArrayList<>();
        MQConst.GoblinQueue stream = MQConst.GoblinQueue.BIZ_ARTWORK_CLQ;
        this.initStream(stringRedisTemplate, stream.getKey(), stream.getGroup());
        for (int i = 0; i < 2; i++) {
            StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer = this.buildStreamMessageListenerContainer(factory);
            subscriptionList.add(listenerContainer.receiveAutoAck(
                    Consumer.from(stream.getGroup(), getConsumerName(stream.name() + i)),
                    StreamOffset.create(stream.getKey(), ReadOffset.lastConsumed()), consumerGoblinBizArtworkClqRdsReceiver
            ));
            listenerContainer.start();
        }
        return subscriptionList;
    }

//    @Bean// 藏品生成
//    public List<Subscription> subscriptionBizArtworkGen(RedisConnectionFactory factory) {
//        List<Subscription> subscriptionList = new ArrayList<>();
//        MQConst.GoblinQueue stream = MQConst.GoblinQueue.BIZ_ARTWORK_GEN;
//        this.initStream(stringRedisTemplate, stream.getKey(), stream.getGroup());
//        for (int i = 0; i < 20; i++) {
//            StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer = this.buildStreamMessageListenerContainer(factory);
//            subscriptionList.add(listenerContainer.receiveAutoAck(
//                    Consumer.from(stream.getGroup(), getConsumerName(stream.name() + i)),
//                    StreamOffset.create(stream.getKey(), ReadOffset.lastConsumed()), consumerGoblinBizArtworkGenRdsReceiver
//            ));
//            listenerContainer.start();
//        }
//        return subscriptionList;
//    }

    @Bean// 增减积分
    public List<Subscription> subscriptionBizIntegral(RedisConnectionFactory factory) {
        List<Subscription> subscriptionList = new ArrayList<>();
        MQConst.GoblinQueue stream = MQConst.GoblinQueue.BIZ_INTEGRAL;
        this.initStream(stringRedisTemplate, stream.getKey(), stream.getGroup());
        for (int i = 0; i < 5; i++) {
            StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer = this.buildStreamMessageListenerContainer(factory);
            subscriptionList.add(listenerContainer.receiveAutoAck(
                    Consumer.from(stream.getGroup(), getConsumerName(stream.name() + i)),
                    StreamOffset.create(stream.getKey(), ReadOffset.lastConsumed()), consumerGoblinBizIntegralReceiver
            ));
            listenerContainer.start();
        }
        return subscriptionList;
    }
}
