package com.liquidnet.service.kylin.controller;

import com.liquidnet.service.kylin.dto.param.RefundCallbackParam;
import com.liquidnet.service.kylin.service.impl.OrderRefundsCallbackServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 退款回掉
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-06-11 6:10 下午
 */
@Api(tags = "前端-退款回调")
@RestController
@RequestMapping("refund")
@Validated
public class OrderRefundCallbackController {

    @Autowired
    private OrderRefundsCallbackServiceImpl orderRefundsCallbackServiceImpl;

    @PostMapping("callback")
    @ApiOperation("退款回调")
    public String refundCallback(RefundCallbackParam refundCallbackParam) {
        String result = orderRefundsCallbackServiceImpl.refundCallback(refundCallbackParam);
        return result;
    }
}
