package com.liquidnet.service.order.controller.inner;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.service.IGoblinNftOrderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotBlank;

@Api(tags = "NFT-支付相关")
@RestController
@Validated
@RequestMapping("/goblin/nft")
public class GoblinInnerNftController {

    @Autowired
    IGoblinNftOrderService iGoblinNftOrderService;

    @PostMapping("airdrop")
    @ApiOperation("空投")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "from", required = true, dataType = "String", name = "code", value = "兑换码", example = "1"),
            @ApiImplicitParam(type = "from", required = true, dataType = "String", name = "userId", value = "用户ID", example = "1"),
    })
    public ResponseDto<Boolean> exchange(
            @RequestParam("code") @NotBlank(message = "兑换码不能为空") String code,
            @RequestParam("userId") @NotBlank(message = "用户ID不能为空") String userId

    ) {
        return iGoblinNftOrderService.exchange(code, userId, "systemAdmin", 4);
    }

}
