package com.liquidnet.service.consumer.sweet.config;

import com.liquidnet.common.cache.redis.config.RedisStreamConfig;
import com.liquidnet.service.consumer.sweet.receiver.ConsumerSweetPosterRdsReceiver;
import lombok.var;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.stream.Consumer;

import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

import java.time.Duration;

import static com.liquidnet.service.base.constant.MQConst.SweetQueue.SWEET_POSTER;

@Configuration
public class ConsumerSweetPosterRdsReceiverConfig extends RedisStreamConfig {
    @Autowired
    ConsumerSweetPosterRdsReceiver consumerSweetPosterRdsReceiver;

    /**
     * 活动海报
     */
    private Subscription receiveSqlPoster(StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer, int t) {
        return listenerContainer.receiveAutoAck(Consumer.from(SWEET_POSTER.getGroup(), getConsumerName(SWEET_POSTER.name() + t)),
                StreamOffset.create(SWEET_POSTER.getKey(), ReadOffset.lastConsumed()), consumerSweetPosterRdsReceiver);
    }

    @Bean
    public Subscription subscriptionSqlPoster0(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlPoster(listenerContainer, 0);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSqlPoster1(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlPoster(listenerContainer, 1);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSqlPoster2(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlPoster(listenerContainer, 2);
        listenerContainer.start();
        return subscription;
    }
}
