package com.liquidnet.service.consumer.sweet.config;

import com.liquidnet.common.cache.redis.config.RedisStreamConfig;
import com.liquidnet.service.consumer.sweet.receiver.ConsumerSweetSqlUserRelationRdsReceiver;
import lombok.var;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

import java.time.Duration;

import static com.liquidnet.service.base.constant.MQConst.SweetQueue.ARTISTS_RELATION;

@Configuration
public class ConsumerSweetSqlUserRelationRedisStreamConfig extends RedisStreamConfig {
    @Autowired
    ConsumerSweetSqlUserRelationRdsReceiver consumerSweetSqlUserRelationRdsReceiver;

    /**
     * 缺票登记
     *
     * @param listenerContainer
     * @param t
     * @return
     */
    private Subscription receiveSqlUserRelation(StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer, int t) {
        return listenerContainer.receiveAutoAck(Consumer.from(ARTISTS_RELATION.getGroup(), getConsumerName(ARTISTS_RELATION.name() + t)),
                StreamOffset.create(ARTISTS_RELATION.getKey(), ReadOffset.lastConsumed()), consumerSweetSqlUserRelationRdsReceiver);
    }

    /* —————————————————————————— ｜ —————————————————————————— ｜ —————————————————————————— */

    /* -------------------------------------------------------- ｜ 缺票登记 */

    @Bean
    public Subscription subscriptionSqlUserRelation0(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlUserRelation(listenerContainer, 0);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSqlUserRelation1(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlUserRelation(listenerContainer, 1);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSqlUserRelation2(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlUserRelation(listenerContainer, 2);
        listenerContainer.start();
        return subscription;
    }

    /* -------------------------------------------------------- ｜  */
}
