package com.liquidnet.client.admin.zhengzai.smile.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NonNull;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * @author TT
 */
@Data
public class SmileUserInvitedVo {

    @ApiModelProperty(value = "姓名")
    @NotEmpty(message = "姓名不能为空")
    private String name;

    @ApiModelProperty(value = "手机号", example = "")
    @NotEmpty(message = "手机号不能为空")
    private String phone;

    @ApiModelProperty(value = "代理描述")
    @NotEmpty(message = "代理描述不能为空")
    private String describe;

    @ApiModelProperty(value = "演出id")
    @NotEmpty(message = "演出id不能为空")
    private String performancesId;

    @ApiModelProperty(value = "票提")
    @NotNull(message = "票提不能为空")
    private BigDecimal ticket;
}
