package com.liquidnet.common.third.xuper.dto;

import lombok.Data;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 分页拉取指定资产已授予碎片列表
 * @class: Xuper001GetStokenReqDto
 * @Package com.liquidnet.common.third.xuper.dto
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/4/18 15:10
 */
@Data
public class Xuper012ListSdsByAstReqDto {
    //资产id
    private long assetId;
    //分页游标，首页设置空字符串，后面的用上页返回的cursor值
    private String cursor = "";
    //每页拉取数量，默认20，最多50（可选）
    private int limit = 20;

    private static final Xuper012ListSdsByAstReqDto obj = new Xuper012ListSdsByAstReqDto();
    public static Xuper012ListSdsByAstReqDto getNew() {
        try {
            return (Xuper012ListSdsByAstReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Xuper012ListSdsByAstReqDto();
        }
    }
}
