package com.liquidnet.service.feign.account.api;

import com.liquidnet.service.account.wallet.dto.WalletCalTransBalanceParam;
import com.liquidnet.service.account.wallet.dto.base.WalletCallResult;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * FeignAccountTaskClent.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2020/11/4
 */
@Service
@FeignClient(name = "liquidnet-service-account", contextId = "sev-account-task", path = "service-account", fallback = FallbackFactory.Default.class)
public interface FeignAccountTaskClient {

    @RequestMapping(value = "wl/costing/transBalance")
    WalletCallResult<?> calTransBalance(WalletCalTransBalanceParam param);
}
