package com.liquidnet.service.kylin.service;

import com.liquidnet.service.kylin.dao.report.PerformanceAgeDataDto;
import com.liquidnet.service.kylin.dao.report.PerformanceCityDataDto;
import com.liquidnet.service.kylin.dao.report.PerformanceProvinceDataDto;
import com.liquidnet.service.kylin.dao.report.PerformanceSexDataDto;

import java.util.List;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: IReportPerformanceService
 * @Package com.liquidnet.service.kylin.service
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/9/23 11:27
 */
public interface IReportPerformanceService {
    /**
     * 获取按省统计数据
     * @param performanceId
     * @return
     */
    List<PerformanceProvinceDataDto> getProvinceDataList(String performanceId);

    /**
     * 获取按城市统计数据
     * @param performanceId
     * @return
     */
    List<PerformanceCityDataDto> getCityDataList(String performanceId);

    /**
     * 获取按年龄统计数据
     * @param performanceId
     * @return
     */
    List<PerformanceAgeDataDto> getAgeDataList(String performanceId);

    /**
     * 获取按性别统计数据
     * @param performanceId
     * @return
     */
    List<PerformanceSexDataDto> getSexDataList(String performanceId);
}
