package com.liquidnet.service.goblin.controller.Inner;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.service.impl.inner.GoblinQueBizArtworkMdbService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Slf4j
@Api(tags = "@API:QUE")
@RestController
@Validated
@RequestMapping("que/mdb")
public class GoblinQueBizMongoController {
    @Autowired
    private GoblinQueBizArtworkMdbService goblinQueBizArtworkMdbService;

    @PostMapping("adapt")
    @ApiOperation("MDB操作:查取`Redis`数据至`Mongo`")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "raw", required = true, dataType = "String", name = "msg", value = "message", example = "{\"collect\":\"GoblinUserDigitalArtworkVo\",\"column\":\"artworkId\",\"bizId\":\"123321\",\"prefix\":\"goblin:u_art:\",\"opType\":1}"),
    })
    public ResponseDto<String> bizMongoAdapt(@RequestBody String msg) {
        return goblinQueBizArtworkMdbService.bizMongoAdaptProcessing(msg);
    }
}
