package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class GoblinListCollectVo implements Serializable, Cloneable{
    @ApiModelProperty(value = "listId")
    private String listId;
    @ApiModelProperty(value = "spuId")
    private String spuId;
    @ApiModelProperty(value = "skuId")
    private String skuId;
    @ApiModelProperty(value = "标签[0-提前购买|1-分段购买]")
    private Integer tagType;
    @ApiModelProperty(value = "android价格")
    private BigDecimal price;
    @ApiModelProperty(value = "苹果价格")
    private BigDecimal priceV;
    @ApiModelProperty(value = "苹果价格id")
    private String productId;
    @ApiModelProperty(value = "开始时间")
    private LocalDateTime timeStart;
    @ApiModelProperty(value = "结束时间")
    private LocalDateTime timeEnd;

    private static final GoblinListCollectVo obj = new GoblinListCollectVo();

    public static GoblinListCollectVo getNew() {
        try {
            return (GoblinListCollectVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new GoblinListCollectVo();
    }
}
