package com.liquidnet.service.bank.currencycloud.constant;

public class BankCcPaymentConstants {

    public enum StatusEnum {
        NEW("new"),
        READY_TO_SEND("ready_to_send"),
        COMPLETED("completed"),
        FAILED("failed"),
        RELEASED("released"),
        SUSPENDED("suspended"),
        AWAITING_AUTHORISATION("awaiting_authorisation"),
        SUBMITTED("submitted"),
        AUTHORISED("authorised"),
        DELETED("deleted"),
        ;

        private String code;

        public static StatusEnum getEnumByCode(String code) {
            StatusEnum[] array = values();
            for (StatusEnum codeEnum : array) {
                if (codeEnum.code.equals(code)) {
                    return codeEnum;
                }
            }
            return null;
        }

        StatusEnum(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }

    }

}
