package com.liquidnet.client.admin.web.controller.zhengzai.goblin;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.core.text.Convert;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.client.admin.zhengzai.goblin.service.IGoblinSelfTagService;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.goblin.entity.GoblinSelfTag;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.stream.Collectors;

@Api(tags = "标签库")
@Controller
@RequestMapping("goblin/tag")
public class GoblinSelfTagAdminController extends BaseController {
    private final String prefix = "zhengzai/goblin/tag";
    private final String tagBelong = "0";
    @Value("${liquidnet.client.admin.platformUrl}")
    private String platformUrl;
    @Autowired
    IGoblinSelfTagService goblinSelfTagService;

    @GetMapping("")
    public String tag(ModelMap mmap) {
        mmap.put("platformUrl", platformUrl);
        return prefix.concat("/tag");
    }

    @RequiresPermissions("goblin:tag:list")
    @RequestMapping("list")
    @ResponseBody
    public TableDataInfo list(GoblinSelfTag selfTag) {
        startPage();
        return getDataTable(listQuery(selfTag));
    }

    private List<GoblinSelfTag> listQuery(GoblinSelfTag selfTag) {
        LambdaQueryWrapper<GoblinSelfTag> lambdaQueryWrapper = Wrappers.lambdaQuery(GoblinSelfTag.class);
        lambdaQueryWrapper.eq(GoblinSelfTag::getDelFlg, "0");
        lambdaQueryWrapper.eq(GoblinSelfTag::getTagBelong, tagBelong);
        if (StringUtils.isNotBlank(selfTag.getTagName())) {
            lambdaQueryWrapper.like(GoblinSelfTag::getTagName, selfTag.getTagName());
        }
        if (StringUtils.isNotBlank(selfTag.getTagType())) {
            lambdaQueryWrapper.eq(GoblinSelfTag::getTagType, selfTag.getTagType());
        }

        lambdaQueryWrapper.select(
                GoblinSelfTag::getTagId,
                GoblinSelfTag::getTagName,
                GoblinSelfTag::getTagPic,
                GoblinSelfTag::getTagType,
                GoblinSelfTag::getCounts
        );

        List<GoblinSelfTag> list = goblinSelfTagService.list(lambdaQueryWrapper);

        if (!CollectionUtils.isEmpty(list)) {
            List<GoblinSelfTag> cts = goblinSelfTagService.countsForList(list.stream().map(GoblinSelfTag::getTagId).collect(Collectors.toList()));
            if (!CollectionUtils.isEmpty(cts)) {
                cts.forEach(ct -> list.forEach(t -> {
                    if (t.getTagId().equals(ct.getTagId())) {
                        t.setCounts(ct.getCounts());
                    }
                }));
            }
        }

        return list;
    }

//    @RequiresPermissions("goblin:tag:export")
//    @Log(title = "店铺管理:标签库:导出", businessType = BusinessType.EXPORT)
//    @PostMapping("export")
//    @ResponseBody
//    public AjaxResult export(GoblinSelfTag selfTag) {
//        List<GoblinSelfTag> list = listQuery(selfTag);
//        ExcelUtil<GoblinSelfExtagExcelDto> excelUtil = new ExcelUtil<>(GoblinSelfExtagExcelDto.class);
//        List<GoblinSelfExtagExcelDto> excelList = new ArrayList<>();
//        list.forEach(r -> excelList.add(GoblinSelfExtagExcelDto.getNew().copy(r)));
//        return excelUtil.exportExcel(excelList, "音乐人标签库");
//    }

    @ApiOperation(value = "新建")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "tagName", value = "标签名称[50]"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "tagPic", value = "标签图片[256]"),
    })
    @Log(title = "店铺管理:标签库:新建", businessType = BusinessType.INSERT)
    @RequiresPermissions("goblin:tag:add")
    @PostMapping("addSave")
    @ResponseBody
    public AjaxResult addSave(String tagName, String tagPic) {
        if (StringUtils.isBlank(tagName) || StringUtils.isBlank(tagPic)) {
            return AjaxResult.warn("参数有误，请核实");
        }
        LambdaQueryWrapper<GoblinSelfTag> queryWrapper = Wrappers.lambdaQuery(GoblinSelfTag.class);
        queryWrapper.eq(GoblinSelfTag::getDelFlg, "0");
        queryWrapper.eq(GoblinSelfTag::getTagBelong, "0");
        queryWrapper.eq(GoblinSelfTag::getTagName, tagName.trim());
        if (goblinSelfTagService.count(queryWrapper) > 0) {
            return AjaxResult.warn("标签名称重复，请核实");
        }

        GoblinSelfTag selfTag = new GoblinSelfTag();

        selfTag.setTagId(IDGenerator.nextMilliId2());
        selfTag.setTagName(tagName.trim());
        selfTag.setTagPic(tagPic);
        selfTag.setTagType("0");
        selfTag.setDelFlg("0");
        selfTag.setCounts(0);
        selfTag.setTagBelong(tagBelong);

        return toAjax(goblinSelfTagService.addSave(selfTag));
    }

    @ApiOperation(value = "编辑")
    @Log(title = "店铺管理:标签库:编辑", businessType = BusinessType.UPDATE)
    @RequiresPermissions("goblin:tag:edit")
    @PostMapping("editSave")
    @ResponseBody
    public AjaxResult editSave(GoblinSelfTag selfTag) {
        if (StringUtils.isBlank(selfTag.getTagName()) || StringUtils.isBlank(selfTag.getTagPic())) {
            return AjaxResult.warn("参数有误，请核实");
        }
        selfTag.setTagName(selfTag.getTagName().trim());
        LambdaQueryWrapper<GoblinSelfTag> queryWrapper = Wrappers.lambdaQuery(GoblinSelfTag.class);
        queryWrapper.eq(GoblinSelfTag::getDelFlg, "0");
        queryWrapper.eq(GoblinSelfTag::getTagBelong, "0");
        queryWrapper.eq(GoblinSelfTag::getTagName, selfTag.getTagName());
        if (goblinSelfTagService.count(queryWrapper) > 0) {
            return AjaxResult.warn("标签名称重复，请核实");
        }

        selfTag.setTagBelong(tagBelong);
        selfTag.setTagType("0");

        return toAjax(goblinSelfTagService.editSave(selfTag));
    }

    @Log(title = "店铺管理:标签库:删除", businessType = BusinessType.DELETE)
    @RequiresPermissions("goblin:tag:rmv")
    @PostMapping("rmv/{tagId}")
    @ResponseBody
    public AjaxResult rmv(@PathVariable("tagId") String tagId) {
        if (StringUtils.isBlank(tagId)) {
            return AjaxResult.warn("请选择至少一条数据操作");
        }
        return toAjax(goblinSelfTagService.remove(Convert.toStrArray(tagId), tagBelong));
    }
}
