package com.liquidnet.service.erp.vo;

import lombok.Data;

@Data
public class LogisticsSyncVo implements Cloneable {

    // 主键,用于logistics_sync_ack回写状态
    private int rec_id;
    // 代表店铺所有属性的唯一编码，用于店铺区分，ERP内支持自定义（ERP店铺界面设置）
    private String shop_no;
    // 原始订单编号，商城或平台订单号
    private String tid;
    // 物流或者快递面单对应的编号
    private String logistics_no;
    // 响应值为代表物流方式的数字，数字对应的物流方式名称单击这里
    private String logistics_type;
    // 发货时间    时间格式：yyyy-MM-dd HH:mm:ss
    private int delivery_term;
    // 1款到发货 2货到付款(包含部分货到付款) 3分期付款
    private String consign_time;
    // 是否拆分发货,1:拆单发货,0:不进行拆单发货
    private String is_part_sync;
    // 子订单编号串，以逗号(,) 分隔,并且长度不固定(is_part_sync非0时才有效)
    private String oids;
    // 平台ID，固定值127
    private String platform_id;
    // 订单ID
    private int trade_id;
    // 代表物流所有属性的唯一编码，用于物流区分，ERP内支持自定义（ERP物流界面设置）
    private String logistics_code_erp;
    // ERP内自定义的物流名称，（对应ERP设置-基本设置-物流界面的物流名称）
    private String logistics_name_erp;
    // 物流方式类型名称，（ERP设置-基本设置-物流界面的物流类型中文名称）
    private String logistics_name;
    // 出库单id
    private int stockout_id;
    // 1:需要同步,0:不需要同步
    private int is_need_sync;
    // 0:等待同步2:同步失败,3:同步成功4:手动设置为同步成功,5:手动取消同步
    private int sync_status;
    //  一个订单要多次同步时，最后一个为1,用于同步回写状态
    private int is_last;
    // 默认为0
    private String shop_id;
    // 默认为0
    private int logistics_id;
    // 同步说明
    private String description;
    // 默认为'0000-00-00 00:00:00'，成功同步时间
    private String sync_time;
    // 默认为0，是否使用淘宝在线发货
    private int is_online;
    // 默认为 ''，平台返回的错误码
    private String error_code;
    // 默认为 ''，平台返回的错误描述
    private String error_msg;
    // 默认为0，重试计数(有些同步失败可重试)
    private int try_times;
    // 最后修改时间， 时间格式：yyyy-MM-dd HH:mm:ss
    private String modified;
    // 创建时间，时间格式：yyyy-MM-dd HH:mm:ss
    private String created;
    // 序列号（存在序列号时返回序列号，无序列号时返回 flag）
    private String sn_list;
}
