package com.liquidnet.service.chime.test;

import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.RandomUtil;
import com.liquidnet.service.chime.biz.ChimeUserBiz;
import com.liquidnet.service.chime.dto.ChimeUserInfoDto;
import com.liquidnet.service.chime.dto.ChimeUserListQueryReqDto;
import com.liquidnet.service.chime.dto.ChimeUserUpdateReqDto;
import com.liquidnet.service.chime.dto.NewPageResult;
import com.liquidnet.service.chime.service.IChimePerformanceService;
import com.liquidnet.service.chime.service.IChimeUserService;
import com.liquidnet.service.chime.utils.DataUtils;
import com.liquidnet.service.chime.vo.mongo.ChimeUserInfoVo;
import com.liquidnet.service.chime.vo.mongo.ChimeUserTagsMappingVo;
import com.mongodb.*;
import lombok.extern.slf4j.Slf4j;
import org.assertj.core.util.Arrays;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.*;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: TestDataUtils
 * @Package com.liquidnet.service.chime.test
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/9/12 15:44
 */
@Slf4j
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
public class TestDataUtils {
    @Autowired
    private DataUtils dataUtils;

    @Autowired
    private ChimeUserBiz chimeUserBiz;

    @Autowired
    private IChimePerformanceService chimePerformanceService;

    @Autowired
    private IChimeUserService chimeUserService;

    @Test
    public void getPerformanceCount(){
        System.out.println(chimeUserBiz.getSexDesc("{\"val\":\"MS01\",\"desc\":\"女3性\"}"));
    }

    @Test
    public void updateUserInfo(){
        String sex = "{\"val\":\"MS01\",\"desc\":\"女性\"}";
        String tags = "[ { \"val\": \"MMS0102\", \"desc\": \"B\" }, { \"val\": \"MMS0101\", \"desc\": \"A\" }, { \"val\": \"MMS0201\", \"desc\": \"C\" } ]";
        ChimeUserUpdateReqDto reqDto = ChimeUserUpdateReqDto.getNew();
//        reqDto.setUserId("TEST202109191447591475263969");
//        reqDto.setUserId("TEST202109191447591490063014");
        reqDto.setUserId("TEST202109191447591501070250");
        reqDto.setSex(sex);
        reqDto.setTags(tags);
        chimeUserService.updateUserInfo(reqDto);
    }

    @Test
    public void updateBatchUser(){
        String userId = "1025440,1046572,1047250,1051519,1051886,1052541,1052624,1052633,1052658,1052844,1053123,1053140,1053326,1053450,1053602,1053903,1053993,1054184,1054372,1054790,1054996,1055207,1055824,1056456,1056599,1056719,1056973,1057131,1057156,1057417,1057638,1057934,1058500,1061407,1062592,1064990,1097897,1097912,1098039,1098051,1098168,1098176,1098358,1099973,1100091,1100255,1100288,1100319,1100704,1101159,1101201,1101522,1101543,1101675,1101689,1101721,1102155,1102257,1102274,1104587,1104702,1105195,1115043,1116036,1118168,11210,1249116,1287543,1290932,1296536,1296799,1307398,1311312,1313721,1317352,1348413,1378400,1385160,138875089434705922147177,1389062,1400802,1414569,1415876,1417742,1443906,1464788,1469260,1502063,1503127,1504757,1543758,1642624,165704,1670224,1693951,1694496,1748039,1750345,1765032,1772729,1774343,1775434,1776204,1786590,1790200,1796999,1798954,1800813,1805393,1807368,1807459,1819493,1847817,186167,1867797,1896833,1914935,1932981,1942513,194259,1965713,1966598,1968155,1968853,1975318,1982905,1983042,201619231988613123117437,2039516,2102624,2138953,2143070,218056,2182828,2185680,2218503,22823,2285687,229452,2330821,248381111041884169309318,248387966612275208678776,248533341460070405638233,248671748626677769389992,248705352108769289961732,251294652761047046069933,28236,300269754670120967462191,321878,324915333229035526185053,324989587509329925766840,325065275375452169307116,327135338001694728401378,328201197282918403690675,339450457938657286585226,354661983115018249398730,354667591654440967967536,354776551951073284575010,354982031290122249856977,354997053017292808008543,355433685642117121444377,356246808762941448619736,356627064204410880392162,356782479185018885910166,357508749178961921568280,357701462470328325737642,358334369438269443275578,358402194609274880942585,358600200407859203365531,358904465029857280759773,360898397515284485417504,361299257131008003745728,361749010838978567944534,362368025475153926914569,362409905093509125513571,364149613389578243413830,364530405785845767756750,367430589577953280622853,367492284014919680138702,367619138138931208105152,368132135320453125904678,368260543521751044078559,368807269249433608755554,369007215826698249513973,369038781068083203145247,369049995630346249275060,369133966599290884377791,369190743223418880679910,369216991550504962853901,369242606584463362555403,369340597182300161681232,369402658671411208237147,369489509234933761617884,369552315665776644042450,369593803879219208268268,369603870339481608507921,369617169298227203556124,369654298582302721882121,369774435234856962304417,370864805410406407891274,370944427816386562610699,371078287938027526454116,371081177809715207604966,371107093704867849665179,371155860286504967026418,371163882320936962717286,371175774128865289504120,371179971872194561394992,371316209203281921221831,371389550925086726077089,371416723265945603332637,371439146061905921849283,371627766382592003333198,371676131447275526455042,371726248888401921075774,371854200125112321632434,372016357743001603337711,372046975319572484844027,372225150909153280445394,372313656097095685343017,372348219879751684753257,373107638380953603141341,374725482776739844361619,376568972196085762193450,379523883107614726174372,380313168363028484884381,382305858621440003213839,382324887172055048718775,382339876066426880887652,382343909057495044270273,382358994878464008532634,382422968035082249167741,382423932649717763016402,382483761203773449640312,382568116882882562655709,382609088941506562349061,382818924387368962986757,382871876129423361436978,382909131120558085204796,382911027952599049460615,383448530904268808191283,383454717829611520283718,383591050497228803031180,383635324232908808798072,383655508141670403049930,383676462003650562724125,383678561677066249761148,383701270142238721969979,383707791781642249275435,383722176184320003307173,383745715663175689281100,383757461694300162412347,383803601890426880226188,383879049273835521011317,383896642411560962748342,383916725871575049908092,384032422727516167448855,384067772317859848386900,384083720202731521872480,384158519071457286074052,385359730692751367078101,385393002348544003626627,385438318363934721798144,385471745704755202323853,385480123365621761816564,385483237929943048880287,385492104739143685362384,385495966849433608802947,385510424620154885777620,385512141046579203032042,385514545602887680514087,385536913663180803833445,385554956463636480564402,385560117386936326841502,385560160886702080828116,385566731426856967748431,385578702054359049341215,385595330830172162134797,385600505058017280748702,385606442934190081107944,385606909047193603526890,385610129215488002519547,385611944015544326410439,385613755488665608137517,385630035424215043381413,385641557474672649110812,385644194727198726486316,385647627090165761486980,385647918384578566498632,385649347015065603648797,385656676384931843735679,385660839990394880491112,385662112122798080783379,385665513116139526633118,385670758550896648875161,385684057056870408514839,385686262510632967720010,385698166989127685878581,385702640965550084490678,385707718887342080402407,385724649694986243636273,385726923892326403947330,385765682822676489378686,385772391956070403294419,385773928539340808225660,385785902223851526024630,385792145697013762026705,385801252202086408831791,385808072979251208313975,385810569512878080102839,385863129976913926773054,385881074584944643398984,385884800930447366342988,385900893552148484669801,385912179677839363121095,385920336173056008795561,385934545795317766443304,385935771458600967993822,385944561251778562222362,385952408421908481154906,385967361320550408462715,385979039651840008334303,385984168693596167177177,385992252120268803089073,386018315902812162152772,386031624563834880448720,386045977262407685312647,386052984513495044239233,386055972959928321348859,386162142826987521496281,386166606535966721828526,386242055974584320701128,386243201237893121831848,386266707082199045195756,386300573612359685824800,386310261481308166315577,386316962846638089783136,386372821631221762872593,386376591592652808916571,386405379072327685703173,386634663297187848669359,386707919425617926330521,386721641254092803907030,386749981659136002462881,386858166897868808193920,386888516458414080113207,387132053645066248275988,387558523722956808058643,389060331272519685478693,389523031035330566909615,390097551399321603822669,390988063249530880516336,391049769136947203957755,391180196099768321544754,391394147919462403203903,393346236648898561834561,393447850369351685167408,393774015643238408244203,398017363928678409151133,398088979614269449394803,398117037868482562147210,398273440453345284603312,398300532460912644029047,401164449624883208837857,403790034977587202819697,407761288583823362694228,407839904386416643454270,407909934503034880735812,407947401554411521274147,407997531666104326742455,408026344768143367047578,408041704356167684922357,408130904446730244528864,408168188240363520689891,408171701602877444907482,408198099466567685716701,408243400084029449898389,408250415099412480359513,408336508096348167471135,408342210551070720888042,408372740512399362862869,408494188383436808278453,408504806092472325418853,408529079036805126264255,408533361006592003161147,43164,465220,50011,550848,552773,602489,767933,795585,823700,922227,932900,959780,974746,982619,985007";
//        String userId = "1025440,1046572,1047250,1052541,1052624,1052633,1052658,1052844,1053123,1053140,1053326,1053450,1053602";

        List<Object> userIdList = Arrays.asList(userId.split(","));
        userIdList.forEach(userIdStr -> {
            ChimeUserInfoVo chimeUserInfoVo = ChimeUserInfoVo.getNew();
            chimeUserInfoVo.setUserId(userIdStr.toString());
            chimeUserInfoVo.setJoinPerformanceId("339669876398694407540550");
            chimeUserInfoVo.setUpdatedAt(LocalDateTime.now().toString());
            dataUtils.updateChimeUser(chimeUserInfoVo);
        });

    }

    @Test
    public void getUserImgList(){
        ExecutorService executorService = Executors.newFixedThreadPool(100);
        Future future = executorService.submit(new Callable(){
            public Object call() throws Exception {
                System.out.println("Asynchronous Callable");
                return "Callable Result";
            }
        });

        try {
            System.out.println("future.get() = " + future.get());
        } catch (InterruptedException e) {
            e.printStackTrace();
        } catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void createUserInfoVo(){
        ExecutorService executorService = Executors.newFixedThreadPool(200);

        long start = System.currentTimeMillis();
        for(int i=0;i<1000000;i++){
            int num = i+1;
            Future future = executorService.submit(new Callable(){
                public Object call() throws Exception {
                    ChimeUserInfoVo chimeUserInfoVo = ChimeUserInfoVo.getNew();
                    chimeUserInfoVo.setUserId("TEST"+ IDGenerator.nextTimeId());
//                    chimeUserInfoVo.setPassWord("123456");
                    chimeUserInfoVo.setSex("男");
//                    chimeUserInfoVo.setUserName("TestName"+num);
//                    chimeUserInfoVo.setUserMobile("1381111"+num);
//                    chimeUserInfoVo.setAvatar("https://img.zhengzai.tv/user/2021/07/27/a4cc2a4e6dcd44d1812dc60e079086b4.png");
//                    chimeUserInfoVo.setUserCover("https://img.zhengzai.tv/user/2021/07/27/a4cc2a4e6dcd44d1812dc60e079086b4.png");
//                    chimeUserInfoVo.setBirthday("2021-09-01");
//                    chimeUserInfoVo.setSignature("测试签名");
//                    chimeUserInfoVo.setArea("山西省 太原市 迎泽区");
                    chimeUserInfoVo.setJoinPerformanceId("-1");
//                    easemobUtil.createUser(chimeUserInfoVo.getUserId(),chimeUserInfoVo.getPassWord());
                    dataUtils.createChimeUser(chimeUserInfoVo);
                    //插入userTagMapping
                    List<ChimeUserTagsMappingVo> userTagList = new ArrayList<>();
                    for(int j=0;j<5;j++){
                        ChimeUserTagsMappingVo chimeUserTagDto = ChimeUserTagsMappingVo.getNew();
                        chimeUserTagDto.setTagCode("tags"+(j+1));
                        chimeUserTagDto.setTagDesc("标签"+(j+1));
                        userTagList.add(chimeUserTagDto);
                    }
                    dataUtils.createUserTagMapping(userTagList);
                    return Boolean.parseBoolean("true");
                }
            });
//            Future future = executorService.submit(new Runnable() {
//                public void run() {
//                    chimeUserInfoVo chimeUserInfoVo = chimeUserInfoVo.getNew();
//                    chimeUserInfoVo.setUserId("TEST"+ IDGenerator.nextTimeId());
//                    chimeUserInfoVo.setPassWord("123456");
//                    chimeUserInfoVo.setSex("男");
//                    chimeUserInfoVo.setUserName("TestName"+num);
//                    chimeUserInfoVo.setUserMobile("1381111"+num);
//                    chimeUserInfoVo.setAvatar("https://img.zhengzai.tv/user/2021/07/27/a4cc2a4e6dcd44d1812dc60e079086b4.png");
//                    chimeUserInfoVo.setUserCover("https://img.zhengzai.tv/user/2021/07/27/a4cc2a4e6dcd44d1812dc60e079086b4.png");
//                    chimeUserInfoVo.setBirthday("2021-09-01");
//                    chimeUserInfoVo.setSignature("测试签名");
//                    chimeUserInfoVo.setArea("山西省 太原市 迎泽区");
//                    chimeUserInfoVo.setJoinPerformanceId("-1");
//                    List<ChimeUserTagDto> imgList = new ArrayList<>();
//                    for(int j=0;j<5;j++){
//                        ChimeUserTagDto chimeUserTagDto = ChimeUserTagDto.getNew();
//                        chimeUserTagDto.setUserId(chimeUserInfoVo.getUserId());
//                        chimeUserTagDto.setTagCode("tags"+(j+1));
//                        chimeUserTagDto.setTagDesc("标签"+(j+1));
//                        imgList.add(chimeUserTagDto);
//                    }
//                    chimeUserInfoVo.setUserTags(imgList);
////                    easemobUtil.createUser(chimeUserInfoVo.getUserId(),chimeUserInfoVo.getPassWord());
//                    dataUtils.createChimeUser(chimeUserInfoVo);
//                }
//            });
            try {
                System.out.println("执行第几个===="+num+" future.get()=="+future.get());
            } catch (InterruptedException e) {
                e.printStackTrace();
            } catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        System.out.println("耗时："+(System.currentTimeMillis() - start)/1000 + "秒");

        executorService.shutdown();
//        EasemobUtil.createUsers();
    }

    @Test
    public void createUserInfoNewVo(){
        ExecutorService executorService = Executors.newFixedThreadPool(200);

        long start = System.currentTimeMillis();
        List<ChimeUserInfoVo> voNewList = new ArrayList<>();

        int totalNum = 400000;
        int pageSize = 1000;
        int pageNum = 1;
        int totalPage = totalNum % pageSize == 0 ? totalNum / pageSize : (totalNum / pageSize) + 1;;
        for(int i=0;i<totalNum;i++){
            try {
                int num = i+1;

                ChimeUserInfoVo chimeUserInfoVo = ChimeUserInfoVo.getNew();
                chimeUserInfoVo.setUserId("TEST"+ IDGenerator.nextTimeId());
                chimeUserInfoVo.setSex("男");
//                chimeUserInfoVo.setUserName("TestName"+num);
//                chimeUserInfoVo.setUserMobile("1381111"+num);
//                chimeUserInfoVo.setAvatar("https://img.zhengzai.tv/user/2021/07/27/a4cc2a4e6dcd44d1812dc60e079086b4.png");
//                chimeUserInfoVo.setBirthday("2021-09-01");
//                chimeUserInfoVo.setSignature("测试签名");
//                chimeUserInfoVo.setArea("山西省 太原市 迎泽区");
                chimeUserInfoVo.setJoinPerformanceId("-1");
//                    easemobUtil.createUser(chimeUserInfoVo.getUserId(),chimeUserInfoVo.getPassWord());
                List<ChimeUserTagsMappingVo> userTagList = new ArrayList<>();
                for(int j=0;j<5;j++){
                    ChimeUserTagsMappingVo chimeUserTagDto = ChimeUserTagsMappingVo.getNew();
                    chimeUserTagDto.setTagCode("tags"+ RandomUtil.getRandomInt(1,10)+j);
                    chimeUserTagDto.setTagDesc("标签"+  RandomUtil.getRandomInt(1,10)+j);
                    userTagList.add(chimeUserTagDto);
                }
                chimeUserInfoVo.setUserTagsVoList(userTagList);
                voNewList.add(chimeUserInfoVo);


                if(num%pageSize==0){
                    dataUtils.createBatchChimeUser(voNewList);
                    voNewList = new ArrayList<>();
//                    Future future = executorService.submit(new Callable(){
//                        public Object call() throws Exception {
//
//                            dataUtils.createBatchChimeUser(voNewList);
//
//                            return Boolean.parseBoolean("true");
//                        }
//                    });
                    System.out.println("=================执行第几批次============"+pageNum);
                    pageNum++;
                }
                System.out.println("执行第几个===="+num);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println("耗时："+(System.currentTimeMillis() - start)/1000 + "秒");

        executorService.shutdown();
//        EasemobUtil.createUsers();
    }

    @Test
    public void testUserList(){
        for(int i=0;i<10;i++){
            long startTime = System.currentTimeMillis();
            ChimeUserListQueryReqDto reqDto = ChimeUserListQueryReqDto.getNew();
//        reqDto.setPerformanceId("-1");
            reqDto.setPerformanceId("-1");
            reqDto.setPageNum(1);
            reqDto.setPageSize(50);
            reqDto.setOrderItem(null);
            reqDto.setOrderSc(null);
            reqDto.setSex("男");
//            reqDto.setTags("tags40,tags80");
            NewPageResult<ChimeUserInfoDto> pageInfo = chimePerformanceService.getUserListByCon(reqDto);
            log.info("总共获取总数pagecount:{}",pageInfo.getList().size());
            pageInfo.getList().forEach(dto -> {
//                System.out.println(dto.getUserId());
//                System.out.println(JsonUtils.toJson(dto.getUserTags()));
            });
            long endTime = System.currentTimeMillis();
            log.info("耗时：{}ms",endTime-startTime);
        }
    }

    @Test
    public void exportData(){
        String user = "admin";                   //用户名
        String database = "admin";              //数据库
        char[] password = "S&y$6d*JwJ".toCharArray();   //密码
        MongoCredential credential = MongoCredential.createCredential(user,database,password);   //验证对象
        MongoClientOptions options = MongoClientOptions.builder().sslEnabled(false).build();     //连接操作对象
        MongoClient mongoClient = new MongoClient(new ServerAddress("s-2ze04ffc16a54af4-pub.mongodb.rds.aliyuncs.com",3717),credential,options);   //连接对象
        DB db = mongoClient.getDB("prod_ln_scene");
        System.out.println(db.getCollection("ChimeUserInfoVo").count());

        db.getCollection("ChimeUserInfoVo").find();
        ChimeUserInfoVo chimeUserInfoVo = ChimeUserInfoVo.getNew();

        //获取kylin的chime
//        String user = "admin";                   //用户名
//        String database = "admin";              //数据库
//        char[] password = "S&y$6d*JwJ".toCharArray();   //密码
//        MongoCredential credential = MongoCredential.createCredential(user,database,password);   //验证对象
//        MongoClientOptions options = MongoClientOptions.builder().sslEnabled(false).build();     //连接操作对象
//        MongoClient mongoClient = new MongoClient(new ServerAddress("s-2ze04ffc16a54af4-pub.mongodb.rds.aliyuncs.com",3717),credential,options);   //连接对象
//        DB db = mongoClient.getDB("prod_ln_scene");
//        System.out.println(db.getCollection("ChimeUserInfoVo").count());
    }


}
