package com.liquidnet.service.executor.main.handler;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.DESUtils;
import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.service.feign.platform.task.FeignPlatformGoblinTaskClient;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;

/**
 * platform:goblin
 */
@Component
public class PlatformGoblinTaskHandler {
    @Value("${liquidnet.service.platform.url}")
    private String sevPlatformUrl;
    @Autowired
    private FeignPlatformGoblinTaskClient feignPlatformGoblinTaskClient;

    @XxlJob(value = "sev-platform:goblinGoodsOnShelvesHandler")
    public void goblinGoodsOnShelvesHandler() {// 商城:商品预约上架
        try {
            XxlJobHelper.handleSuccess("结果：" + feignPlatformGoblinTaskClient.goodsOnShelvesHandler().toJson());
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }

    @XxlJob(value = "sev-platform:goblinStoreMarketActivityHandler")
    public void goblinStoreMarketActivityHandler() {// 商城:商铺活动开启关闭
        try {
            XxlJobHelper.handleSuccess("结果：" + feignPlatformGoblinTaskClient.storeMarketActivityHandler().toJson());
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }
    @XxlJob(value = "sev-platform:goblinSetCount")
    public void setCount() {// 设置商城 商品数量
        try {
            XxlJobHelper.handleSuccess("结果：" + feignPlatformGoblinTaskClient.setCount().toJson());
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }

    @XxlJob(value = "sev-platform:codeCount")
    public void codeCount() {// 兑换码定时生成
        try {
            XxlJobHelper.handleSuccess("结果：" + feignPlatformGoblinTaskClient.codeCount().toJson());
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }

    @XxlJob(value = "sev-platform:getNotPayNum")
    public void getNotPayNum() {// 查询待支付订单数量
        try {
            XxlJobHelper.handleSuccess("结果：" + feignPlatformGoblinTaskClient.getNotPayNum().toJson());
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }

    @XxlJob(value = "sev-platform:goblinArtworkTransferExpireHandler")
    public void goblinArtworkTransferExpireHandler() {// 商城:藏品转赠过期处理
        try {
            String url = sevPlatformUrl.concat("/platform/artwork/task/transfer_expire");
            LinkedMultiValueMap<String, String> paramsMap = CollectionUtil.linkedMultiValueMapStringString();
            String jobParam = XxlJobHelper.getJobParam();
            if (StringUtils.isNotBlank(jobParam)) {
                paramsMap.add("expiredSeconds", DESUtils.DES().encrypt(jobParam));
            }
            LinkedMultiValueMap<String, String> headersMap = CollectionUtil.linkedMultiValueMapStringString();
            headersMap.add("Accept", MediaType.APPLICATION_JSON_UTF8_VALUE);
            headersMap.add("Content-Type", MediaType.APPLICATION_FORM_URLENCODED_VALUE);

            XxlJobHelper.handleSuccess("结果：" + HttpUtil.post(url, paramsMap, headersMap));
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }
}
