package com.liquidnet.service.goblin.dto.manage;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;

@ApiModel(value = "GoblinStorePurchaseItemParam")
@Data
public class GoblinStoreZhengzaiItemParam {
    @ApiModelProperty(required = true, value = "skuId", example = "1")
    @NotBlank(message = "skuId不能为空")
    private String skuId;
    @ApiModelProperty(required = true, value = "活动价格", example = "1.00")
    @NotBlank(message = "活动价格不能为空")
    private BigDecimal priceMarketing;
    @ApiModelProperty(required = true, value = "活动库存", example = "1.00")
    @NotBlank(message = "活动库存不能为空")
    private Integer stockMarketing;
    @ApiModelProperty(required = true, value = "用户限购[0-不限购|x-限购数量]", example = "1")
    @NotBlank(message = "用户限购类型不能为空")
    private Integer buyLimit;
    @ApiModelProperty(required = true, value = "购买条件[0-全部用户|1-仅支持会员|2-指定用户可买]", example = "1")
    @NotBlank(message = "购买条件不能为空")
    private Integer buyFactor;
    @ApiModelProperty(required = false, value = "购买限制人员名单[购买限制为2-指定用户时必填]", example = "")
    private String buyRoster;
    @ApiModelProperty(required = false, value = "操作指定可买用户类型 [1-添加|2-删除]", example = "")
    private String type;
}



