package com.liquidnet.service.account.common;

public class ErrorConstants {
    public static final String PROCESSING_CODE = "1000";
    public static final String SUCCESS_CODE = "2000";
    public static final String SUCCESS_DETAILS = "isOk";
    private static final String FAILED_CODE = "3000";
    private static String getFailedErrorCode(String code) {
        return FAILED_CODE + code;
    }

    // 系统异常
    public static final String SYSTEM_ERROR_CODE = "5000";
    public static final String SYSTEM_ERROR_DESC = "System Abnormal";

    // 参数异常
    public static final String PARAMS_VALUE_ERROR_CODE = getFailedErrorCode("101");
    public static final String PARAMS_VALUE_ERROR_DESC = "Invalid Parameter";
    public static final String PARAMS_TYPE_ERROR_CODE = getFailedErrorCode("102");
    public static final String PARAMS_TYPE_ERROR_DETAIL = "参数类型不正确";
    public static final String PARAMS_INOUT_AMT_ERROR_CODE = getFailedErrorCode("103");
    public static final String PARAMS_INOUT_AMT_ERROR_DETAIL = "出入账金额对不上";

    public static final String SUBJECT_CREATE_ERROR_CODE = getFailedErrorCode("201");
    public static final String SUBJECT_CREATE_ERROR_DESC = "Wallet subject creation failed";
    public static final String WALLET_CONFIG_ERROR_CODE = getFailedErrorCode("202");
    public static final String WALLET_CONFIG_ERROR_DESC = "Incorrect wallet configuration";
    public static final String WALLET_CREATE_ERROR_CODE = getFailedErrorCode("203");
    public static final String WALLET_CREATE_ERROR_DESC = "Wallet creation failed";
    public static final String WALLET_EDIT_ERROR_CODE = getFailedErrorCode("204");
    public static final String WALLET_EDIT_ERROR_DESC = "Wallet edit failed";
    public static final String WALLET_QUERY_ERROR_CODE = getFailedErrorCode("205");
    public static final String WALLET_QUERY_ERROR_DESC = "Wallet query failed";
    public static final String WALLET_TRANS_ERROR_CODE = getFailedErrorCode("206");
    public static final String WALLET_TRANS_ERROR_DESC = "Wallet transaction failed";
    public static final String WALLET_COST_ERROR_CODE = getFailedErrorCode("207");
    public static final String WALLET_COST_ERROR_DESC = "Wallet costing failed";
    public static final String WALLET_DASHBOARD_ERROR_CODE = getFailedErrorCode("208");
    public static final String WALLET_DASHBOARD_ERROR_DESC = "Wallet dashboard show failed";


    // 账户操作异常
    public static final String ACCOUNT_CREATE_ERROR_CODE = getFailedErrorCode("201");
    public static final String ACCOUNT_CREATE_ERROR_DESC = "Funding account creation failed";
    public static final String ACCOUNT_UPDATE_ERROR_CODE = getFailedErrorCode("202");
    public static final String ACCOUNT_UPDATE_ERROR_DESC = "Funding account creation failed";
//    public static final String ACCOUNT_NOT_FOUND_CODE = getFailedErrorCode("203");
//    public static final String ACCOUNT_NOT_FOUND_DETAIL = "账户信息缺失";
//    public static final String ACCOUNT_UNNORMAL_CODE = getFailedErrorCode("204");
//    public static final String ACCOUNT_UNNORMAL_DETAIL = "账户状态异常";
//    public static final String ACCOUNT_CONFIGERR_CODE = getFailedErrorCode("205");
//    public static final String ACCOUNT_CONFIGERR_DETAIL = "账户配置有误";

    // 账本操作异常
    public static final String ACCTRANS_CREATE_ERROR_CODE = getFailedErrorCode("301");
    public static final String ACCTRANS_CREATE_ERROR_DETAIL = "账本创建失败";
    public static final String ACCTRANS_UPDATE_ERROR_CODE = getFailedErrorCode("302");
    public static final String ACCTRANS_UPDATE_ERROR_DETAIL = "账本更新失败";
    public static final String ACCTRANS_ORGTRANS_NOTFOUND_CODE = getFailedErrorCode("303");
    public static final String ACCTRANS_ORGTRANS_NOTFOUND_DETAIL = "关联账本未找到";

    // 业务操作异常
    public static final String BUSINESS_ERROR_CODE = getFailedErrorCode("401");
    public static final String BUSINESS_ERROR_DESC = "业务处理失败";
    public static final String BUSINESS_REQUEST_REFUSED_CODE = getFailedErrorCode("402");
    public static final String BUSINESS_REQUEST_REFUSED_DETAIL = "交易拒绝，请确认是否已开通此接口";
    public static final String BUSINESS_NODATA_CODE = getFailedErrorCode("403");
    public static final String BUSINESS_NODATA_DETAIL = "无相关数据";
    public static final String BUSINESS_ORGTRADE_NOTFOUND_CODE = getFailedErrorCode("404");
    public static final String BUSINESS_ORGTRADE_NOTFOUND_DETAIL = "原交易不存在";
}
