package com.liquidnet.service.reconciliation.controller.task;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.reconciliation.biz.ReconciliationMainBiz;
import com.liquidnet.service.reconciliation.util.FundFlowUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.text.ParseException;
import java.util.*;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description: TODO
 * @class: TaskCreateBatchLiquidnetWalletController
 * @Package com.liquidnet.service.reconciliation.controller.task
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/10/27 14:00
 */
@Api(tags = "recon-task")
@RestController
@RequestMapping("/recon/task")
public class TaskAccountCheckController {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private FundFlowUtil fundFlowUtil;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "accountCheck")
    @GetMapping(value = "/accountCheck")
    public void accountCheck(String bankChannel,String beginDate,String endDate,String unit,String offset,String beginOffset,String endOffset) {
        log.info("accountCheck: bankChannel:{} beginDate:{} ", bankChannel,beginDate,endDate,unit,offset,beginOffset,endOffset);
        Map<String,Date> dateMap = this.getBeginDateAndEndDate(beginDate,endDate,unit,offset,beginOffset,endOffset);
        final Date _beginDate = dateMap.get("beginDate");
        final Date _endDate = dateMap.get("endDate");

        if(StringUtil.isNotEmpty(bankChannel)){
            String[] bankChannelArray = bankChannel.split(",");
            List<String> bankChannelList = Arrays.asList(bankChannelArray);
            bankChannelList.forEach(bankChannelStr -> {
                long days = DateUtil.intervalDays(_beginDate,_endDate);
                for(int i = 0;i < days;i++){
                    Date _begin = DateUtil.addDay(_beginDate,i);
                    Date _end = DateUtil.addDay(_begin,1);
                    String beginDateStr = DateUtil.format(_begin,DateUtil.Formatter.yyyy_MM_dd);
                    String endDateStr = DateUtil.format(_end,DateUtil.Formatter.yyyy_MM_dd);
                    log.info("accountCheck bankChannel:{} beginDate:{} endDate:{}",bankChannelStr,beginDateStr,endDateStr);
                    boolean result = fundFlowUtil.accountingMain(bankChannelStr,_begin,_end);
                    log.info("accountCheck bankChannel:{} beginDate:{} endDate:{} finished result:{}",bankChannelStr,beginDateStr,endDateStr,result);
                }

            });
        }
//        return ResponseEntity.ok("This is `service-example` api.test: ");
    }

    private Map<String, Date> getBeginDateAndEndDate(String beginDate,String endDate,String unit,String offset,String beginOffset,String endOffset){
        Map<String, Date> dateMap = new HashMap<>();
        Date _begin = null;
        Date begin = null;
        try {
            _begin = DateUtil.parse(DateUtil.getNowTime(DateUtil.DATE_SMALL_STR),DateUtil.DATE_SMALL_STR);
            begin = _begin;
        } catch (ParseException e) {
            e.printStackTrace();
        }
        Date _end = null;
        Date end = null;
        try {
            _end = DateUtil.parse(DateUtil.getNowTime(DateUtil.DATE_SMALL_STR),DateUtil.DATE_SMALL_STR);
            end = _end;
        } catch (ParseException e) {
            e.printStackTrace();
        }

        if (StringUtil.isEmpty(offset)) {
            offset = "-1";
        }

        if (StringUtil.isEmpty(unit)) {
            unit = "d";
        }

        if (unit.equals("s")) {
            begin = DateUtils.addSeconds(_begin, Integer.parseInt(offset));
        }
        if (unit.equals("h")) {
            begin = DateUtils.addHours(_begin, Integer.parseInt(offset));
        }
        if (unit.equals("d")) {
            begin = DateUtils.addDays(_begin, Integer.parseInt(offset));
        }

        if (StringUtil.isNotEmpty(beginDate) && StringUtil.isNotEmpty(endDate)) {
            try {
                begin = DateUtil.parse(beginDate,DateUtil.DATE_SMALL_STR);
                end = DateUtil.parse(endDate,DateUtil.DATE_SMALL_STR);
            } catch (ParseException e) {
                e.printStackTrace();
            }
        }

        if (StringUtil.isNotEmpty(beginOffset)) {
            if (unit.equals("s")) {
                begin = DateUtils.addSeconds(_begin, Integer.parseInt(beginOffset));
            }
            if (unit.equals("h")) {
                begin = DateUtils.addHours(_begin, Integer.parseInt(beginOffset));
            }
            if (unit.equals("d")) {
                begin = DateUtils.addDays(_begin, Integer.parseInt(beginOffset));
            }

        }

        if (StringUtil.isNotEmpty(endOffset)) {
            if (unit.equals("s")) {
                end = DateUtils.addSeconds(_end, Integer.parseInt(endOffset));
            }
            if (unit.equals("h")) {
                end = DateUtils.addHours(_end, Integer.parseInt(endOffset));
            }
            if (unit.equals("d")) {
                end = DateUtils.addDays(_end, Integer.parseInt(endOffset));
            }

        }
        dateMap.put("beginDate",begin);
        dateMap.put("endDate",end);
        log.info(String.format("begin:%s , end:%s", begin, end));
        return dateMap;
    }
}
