package com.liquidnet.service.candy.dto.admin;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@ApiModel(value = "CandyMemberCouponMatchParam", description = "会员权益券配置入参")
@Data
public class CandyMemberCouponMatchParam {
    @ApiModelProperty(required = true, value = "会员类型ID[64]", example = "1")
    @NotBlank(message = "会员类型ID不能为空")
    private String memberId;
    @ApiModelProperty(required = true, value = "权益ID[64]", example = "21269184646476")
    @NotBlank(message = "会员权益ID不能为空")
    private String mrightsId;

    @NotBlank(message = "权益券ID不能为空")
    @ApiModelProperty(required = true, value = "券ID", example = "20211111161557612")
    private String couponId;
    @NotNull(message = "券类别不能为空")
    @ApiModelProperty(required = true, value = "业务类别[0-全场｜1-演出｜2-商品｜3-优先购]", allowableValues = "0,1,2,3")
    private Integer busiType;
    @NotNull(message = "券类型不能为空")
//    @ApiModelProperty(required = true, value = "券类型[1-代金券｜2-满减券｜3-兑换券｜4-折扣券｜101-优先券]", allowableValues = "1,2,3,4,101")
    @ApiModelProperty(required = true, value = "券类型[1-代金券｜2-满减券｜4-折扣券｜101-优先券]", allowableValues = "1,2,4,101")
    private Integer couType;

    @NotNull(message = "券发放量不能为空")
    @Max(value = 100, message = "发放量不满足1～100范围")
    @Min(value = 1, message = "发放量不满足1～100范围")
    @ApiModelProperty(required = true, value = "发放量", example = "1")
    private Integer eventAmt;

    @ApiModelProperty(required = true, value = "权益券操作类型[1-添加｜2-删除｜3-编辑]")
    @NotNull(message = "操作类型不能为空")
    private Integer oper;
    @ApiModelProperty(required = false, value = "券ID（仅`state=3-编辑`时必填`）")
    private String operCouponId;
}
