package com.liquidnet.service.consumer.base.config;

import com.liquidnet.common.cache.redis.config.RedisStreamConfig;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.consumer.base.receiver.ConsumerGalaxyJsonNftPublishAndBuyReceiver;
import com.liquidnet.service.consumer.base.receiver.ConsumerGalaxyJsonNftUserRegisterReceiver;
import com.liquidnet.service.consumer.base.receiver.ConsumerGoblinBizArtworkUplReceiver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

import java.util.ArrayList;
import java.util.List;

/**
 * 公共的业务队列消息消费器初始化配置
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2022/6/2
 */
@Configuration
public class ConsumerCommonBizRedisStreamConfig extends RedisStreamConfig {
    @Autowired
    StringRedisTemplate stringRedisTemplate;
    @Autowired
    ConsumerGoblinBizArtworkUplReceiver consumerGoblinBizArtworkUplReceiver;
    @Autowired
    private ConsumerGalaxyJsonNftPublishAndBuyReceiver jsonNftPublishAndBuyReceiver;
    @Autowired
    private ConsumerGalaxyJsonNftUserRegisterReceiver jsonNftUserRegisterReceiver;

    @Bean// 藏品上传声明
    public List<Subscription> subscriptionGoblinBizArtworkUpl(RedisConnectionFactory factory) {
        List<Subscription> subscriptionList = new ArrayList<>();
        MQConst.GoblinQueue stream = MQConst.GoblinQueue.BIZ_ARTWORK_UPL;
        this.initStream(stringRedisTemplate, stream.getKey(), stream.getGroup());
        for (int i = 0; i < 1; i++) {
            StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer = this.buildStreamMessageListenerContainer(factory);
            subscriptionList.add(listenerContainer.receiveAutoAck(
                    Consumer.from(stream.getGroup(), getConsumerName(stream.name() + i)),
                    StreamOffset.create(stream.getKey(), ReadOffset.lastConsumed()), consumerGoblinBizArtworkUplReceiver
            ));
            listenerContainer.start();
        }
        return subscriptionList;
    }

    /**
     * galaxy发行和购买
     * @param factory
     * @return
     */
    @Bean
    public List<Subscription> subscriptionGalaxyJsonNftPublishAndBuy(RedisConnectionFactory factory) {
        List<Subscription> subscriptionList = new ArrayList<>();
        MQConst.GalaxyQueue stream = MQConst.GalaxyQueue.JSON_NFT_PUBLISH_AND_BUY;

        this.initStream(stringRedisTemplate, stream.getKey(), stream.getGroup());
        for (int i = 0; i < 20; i++) {
            StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer = this.buildStreamMessageListenerContainer(factory);
            subscriptionList.add(listenerContainer.receiveAutoAck(
                    Consumer.from(stream.getGroup(), getConsumerName(stream.name() + i)),
                    StreamOffset.create(stream.getKey(), ReadOffset.lastConsumed()), jsonNftPublishAndBuyReceiver
            ));
            listenerContainer.start();
        }
        return subscriptionList;
    }

    /**
     * Galaxy数字账户开通
     * @param factory
     * @return
     */
    @Bean
    public List<Subscription> subscriptionGalaxyJsonNftUserRegister(RedisConnectionFactory factory) {
        List<Subscription> subscriptionList = new ArrayList<>();
        MQConst.GalaxyQueue stream = MQConst.GalaxyQueue.JSON_NFT_USER_REGISTER;

        this.initStream(stringRedisTemplate, stream.getKey(), stream.getGroup());
        for (int i = 0; i < 10; i++) {
            StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer = this.buildStreamMessageListenerContainer(factory);
            subscriptionList.add(listenerContainer.receiveAutoAck(
                    Consumer.from(stream.getGroup(), getConsumerName(stream.name() + i)),
                    StreamOffset.create(stream.getKey(), ReadOffset.lastConsumed()), jsonNftUserRegisterReceiver
            ));
            listenerContainer.start();
        }
        return subscriptionList;
    }
}
