package com.liquidnet.service.sweet.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 正在现场服务号关注事件储存用户信息表
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-08-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SweetWechatUser implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * user_id
     */
    private String userId;

    /**
     * openId
     */
    @TableField("openId")
    private String openId;

    /**
     * unionId
     */
    @TableField("unionId")
    private String unionId;

    /**
     * 昵称
     */
    private String nickname;

    /**
     * 性别
     */
    @TableField("sexDesc")
    private String sexDesc;

    /**
     * 性别 男1
     */
    private Integer sex;

    /**
     * 头像
     */
    @TableField("headImgUrl")
    private String headImgUrl;

    /**
     * zh_CN
     */
    private String language;

    /**
     * 国家
     */
    private String country;

    /**
     * 省
     */
    private String province;

    /**
     * 市
     */
    private String city;

    /**
     * 关注时间
     */
    @TableField("subscribeTime")
    private LocalDateTime subscribeTime;

    /**
     * ADD_SCENE_SEARCH 关注方式
     */
    @TableField("subscribeScene")
    private String subscribeScene;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;

    private static final SweetWechatUser obj = new SweetWechatUser();
    public static SweetWechatUser getNew() {
        try {
            return (SweetWechatUser) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetWechatUser();
        }
    }


}
