package com.liquidnet.service.goblin.dto.manage;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;


@ApiModel(value = "GoblinOrderParam")
@Data
public class GoblinOrderParam {

    @ApiModelProperty(required = false, value = "收货地址id[虚拟物品不需要]")
    private ArrayList<String> addressIds;
    @ApiModelProperty(value = "代理id")
    private String agentId;
    @ApiModelProperty(value = "支付类型")
    @NotNull(message = "支付类型不能为空")
    private String payType;
    @ApiModelProperty(value = "支付来源")
    @NotNull(message = "支付来源不能为空")
    private String deviceFrom;
    @ApiModelProperty(value = "openId")
    private String openId;
    @ApiModelProperty(value = "showUrl")
    private String showUrl;
    @ApiModelProperty(value = "returnUrl")
    private String returnUrl;

    @ApiModelProperty(value = "商品相关参数集合")
    private List<GoblinOrderSpuParam> goblinOrderSpuParamList;

}
