package com.liquidnet.service.goblin.param;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 精选商品
 *
 * @author liquidnet
 * @since 2022-01-04
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinFrontSelectGoodsParam implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 商品id
     */
    private String selectGoodsId;

    /**
     * spu的 ids拼接
     */
    private String goodsId;

    /**
     * 0未删除1已删除
     */
    private Integer delTag;

    /**
     * 创建时间
     */
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime createTime;

    /**
     * 修改时间
     */
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime updateTime;
    /**
     * 1、上架时间2、销量3、价格高到低4、价格低到高
     */
    private  int orderType;


}
