package com.liquidnet.service.bank.currencycloud.service.impl;

import com.alibaba.fastjson.JSON;
import com.currencycloud.client.CurrencyCloudClient;
import com.currencycloud.client.exception.ApiException;
import com.currencycloud.client.model.ConversionDates;
import com.liquidnet.common.exception.constant.ErrorCode;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.bank.currencycloud.dto.BankCcConversionDatesDto;
import com.liquidnet.service.bank.currencycloud.service.IBankCcReferenceService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author lightnet
 * @since 2020-09-08
 */
@Service("bankCcReferenceService")
@Slf4j
public class BankCcReferenceServiceImpl implements IBankCcReferenceService {

    @Autowired
    CurrencyCloudClient currencyCloudClient;

    @Override
    public ResponseDto<List<Map<String, String>>> getBeneficiaryRequirements(String currency, String bankAccountCountry, String beneficiaryCountry) {
        String logFx = "cc get beneficiary requirements.";
        try {

            List<Map<String, String>> maps = currencyCloudClient.beneficiaryRequiredDetails(currency, bankAccountCountry, beneficiaryCountry);

            return ResponseDto.success(maps);
        } catch (ApiException e) {
            log.error(logFx + "api eroor, errorCode=[{}],errors=[{}]", e.getErrorCode(), e.getErrors());
            return ResponseDto.failure(e.getErrorCode(), e.getMessage());
        } catch (Exception e) {
            log.error(logFx + "exception eroor:[{}]", JSON.toJSONString(e));
            return ResponseDto.failure(ErrorCode.HTTP_SYSTEM_ERROR);
        }
    }

    @Override
    public ResponseDto<BankCcConversionDatesDto> getConversionDates(String conversionPair, Date startDate) {
        String logFx = "Get conversion dates.";
        try {
            BankCcConversionDatesDto dto = new BankCcConversionDatesDto();
            ConversionDates conversionDates = currencyCloudClient.conversionDates(conversionPair, startDate);
            BeanUtils.copyProperties(conversionDates, dto);

            return ResponseDto.success(dto);
        } catch (ApiException e) {
            log.error(logFx + "api eroor, errorCode=[{}],errors=[{}]", e.getErrorCode(), e.getErrors());
            return ResponseDto.failure(e.getErrorCode(), e.getMessage());
        } catch (Exception e) {
            log.error(logFx + "exception eroor:[{}]", JSON.toJSONString(e));
            return ResponseDto.failure(ErrorCode.HTTP_SYSTEM_ERROR);
        }
    }

}
