package com.liquidnet.service.sequence.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.service.sequence.service.processor.SysIncrementProcessor;
import com.liquidnet.service.sequence.service.processor.SysSnowflakeProcessor;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

/**
 * SequenceController.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2020/9/24
 */
@Api(tags = "Sequence generator")
@RestController
public class SequenceController {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SysIncrementProcessor incrementProcessor;
    @Autowired
    private SysSnowflakeProcessor snowflakeProcessor;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "Get the next increment sequence")
    @GetMapping("nextIncrId/{sn}")
    public Long nextIncrId(@PathVariable(value = "sn") String seqName) {
        return incrementProcessor.nextId(seqName);
    }

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "Get the next snowflake id")
    @GetMapping("nextId")
    public Long nextId() {
        return snowflakeProcessor.nextId(null);
    }

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "Get the next batch of snowflake IDs")
    @GetMapping("nextId/{number}")
    public Long[] nextId(@PathVariable(value = "number") int number) {
        Long[] seqs = new Long[number];
        for (int i = 0; i < number; i++) {
            seqs[i] = snowflakeProcessor.nextId(null);
        }
        return seqs;
    }
}
