package com.liquidnet.service.account.wallet.dto;

import com.liquidnet.service.account.wallet.dto.base.WalletCallResult;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * WalletTransactionResult.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2020/10/23
 */
@ApiModel(value = "WalletTransactionResult", description = "Result of wallet transaction")
public class WalletTransactionResult extends WalletCallResult<WalletTransactionParam> {
    private static final long serialVersionUID = 6067394499682681231L;
    @ApiModelProperty(position = 11, required = true, value = "Wallet transaction number [64]")
    private String transNo;

    public WalletTransactionResult() {
    }

    public WalletTransactionResult(String transNo) {
        this.transNo = transNo;
    }

    public WalletTransactionResult(String code, String message) {
        super(code, message);
    }

    public String getTransNo() {
        return transNo;
    }
}
