package com.liquidnet.service.bank.currencycloud.controller;

import com.liquidnet.common.swagger.config.SwaggerApiVersion;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.bank.common.BankResultDto;
import com.liquidnet.service.bank.config.swagger.BankSwaggerApiVersionConstant;
import com.liquidnet.service.bank.currencycloud.dto.BankCcBeneficiaryParam;
import com.liquidnet.service.bank.currencycloud.service.IBankCcBeneficiaryService;
import com.liquidnet.service.bank.currencycloud.service.IBankCcReferenceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * currency cloud beneficiaries table 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2020-10-12
 */
@Api(tags = "beneficiary")
@Slf4j
@RestController
@RequestMapping("/bank-cc-beneficiary")
public class BankCcBeneficiaryController {

    @Autowired
    private IBankCcReferenceService bankCcReferenceService;

    @Autowired
    private IBankCcBeneficiaryService bankCcBeneficiaryService;

    @SwaggerApiVersion(group = BankSwaggerApiVersionConstant.API_CC)
    @ApiOperation(value = "create beneficiary")
    @PostMapping(value = "/create")
    public ResponseDto<BankCcBeneficiaryParam> list(@ModelAttribute BankCcBeneficiaryParam createParam) {
        BankResultDto<BankCcBeneficiaryParam> beneficiary = bankCcBeneficiaryService.createBeneficiary(createParam);
        return BankResultDto.getResponseDto(beneficiary);
    }

    @SwaggerApiVersion(group = BankSwaggerApiVersionConstant.API_CC)
    @ApiOperation(value = "list beneficiary requirements")
    @ApiImplicitParams({
            @ApiImplicitParam(paramType = "query", dataType = "String", name = "currency", value = "Currency in which money is held in the beneficiary's bank account. Three-letter currency code in uppercase."),
            @ApiImplicitParam(paramType = "query", dataType = "String", name = "bankAccountCountry", value = "Two-letter country code."),
            @ApiImplicitParam(paramType = "query", dataType = "String", name = "beneficiaryCountry", value = "Two-letter country code. If the beneficiary is a company, the country in which the company is registered. If the beneficiary is an individual, a country in which the beneficiary holds nationality.")
    })
    @GetMapping(value = "/required_details")
    public ResponseDto<List<Map<String, String>>> list(
            @RequestParam("currency") String currency,
            @RequestParam("bankAccountCountry") String bankAccountCountry,
            @RequestParam("beneficiaryCountry") String beneficiaryCountry) {

        return bankCcReferenceService.getBeneficiaryRequirements(currency, bankAccountCountry, beneficiaryCountry);
    }

}
