package com.liquidnet.service.bank.currencycloud.controller;

import com.liquidnet.common.swagger.config.SwaggerApiVersion;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.bank.common.BankResultDto;
import com.liquidnet.service.bank.config.swagger.BankSwaggerApiVersionConstant;
import com.liquidnet.service.bank.currencycloud.dto.BankCcRateDto;
import com.liquidnet.service.bank.currencycloud.dto.BankCcRateParam;
import com.liquidnet.service.bank.currencycloud.service.IBankCcRateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@Api(tags = "rate")
@Slf4j
@RestController
@RequestMapping("/bank-cc-rate")
public class BankCcRateController {

    @Autowired
    private IBankCcRateService bankCcRateService;

    @SwaggerApiVersion(group = BankSwaggerApiVersionConstant.API_CC)
    @ApiOperation(value = "cc detailed rate")
    @PostMapping(value = "/detailed_rate")
    public ResponseDto<BankCcRateDto> detailedRates(@RequestBody BankCcRateParam param) {
        BankResultDto<BankCcRateDto> resultDto = bankCcRateService.detailedRate(param);
        return BankResultDto.getResponseDto(resultDto);
    }

}
