package com.liquidnet.service.bank.currencycloud.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
@ApiModel(description = "payer param")
public class BankCcPayerParam {

    @ApiModelProperty(value = "Legal entity enum : [company/individual]", required = true)
    private String legalEntityType;

    @ApiModelProperty(value = "companyName")
    private String companyName;

    @ApiModelProperty(value = "firstName")
    private String firstName;

    @ApiModelProperty(value = "lastName")
    private String lastName;

    @ApiModelProperty(value = "address", required = true)
    private List<String> address;

    @ApiModelProperty(value = "city")
    private String city;

    @ApiModelProperty(value = "stateOrProvince", required = true)
    private String stateOrProvince;

    @ApiModelProperty
    private String country;

    @ApiModelProperty
    private String identificationType;

    @ApiModelProperty
    private String identificationValue;

    @ApiModelProperty(value = "postcode", required = true)
    private String postcode;

    @ApiModelProperty
    private Date dateOfBirth;

}
