package com.liquidnet.service.adam.controller.admin;

import com.liquidnet.common.exception.LiquidnetServiceException;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.ModelAttribute;

import javax.servlet.http.HttpServletRequest;
import java.time.LocalDateTime;
import java.time.temporal.ChronoField;
import java.util.regex.Pattern;

@Slf4j
public class AdamBaseController {

    @ModelAttribute
    public void accessExecuting(HttpServletRequest request) {
        String alis = request.getHeader("alis");
        LocalDateTime now = LocalDateTime.now();
        int hour = now.get(ChronoField.HOUR_OF_DAY), minute = now.getMinute(), dom = now.get(ChronoField.DAY_OF_MONTH);;
        String lns = "^(" + (dom % 10) + hour % (minute / 10) + "[A-Z]{2})" + minute / 10 + "[0-9]{1}$";
        log.info("lns:{},alis:{}", lns, alis);
        if (StringUtils.isEmpty(alis) || !Pattern.matches(lns, alis)) {
            throw new LiquidnetServiceException("44444", "非法操作");
        }
    }

//    public static String getPostStr(HttpServletRequest request) throws IOException {
//        int contentLength = request.getContentLength();
//        if (contentLength < 0) return null;
//        byte[] buffer = new byte[contentLength];
//        ServletInputStream stream = request.getInputStream();
//        for (int i = 0; i < contentLength; ) {
//            int readline = stream.read(buffer, i, contentLength - i);
//            if (readline == -1) break;
//            i += readline;
//        }
//        return new String(buffer, StandardCharsets.UTF_8);
//    }
}
