package com.liquidnet.service.adam.service.processor;

import com.liquidnet.commons.lang.util.ServletUtils;
import com.liquidnet.service.adam.dto.vo.AdamAddressesVo;
import com.liquidnet.service.adam.entity.AdamAddresses;
import com.liquidnet.service.adam.service.DataMigrationProcessorService;
import com.liquidnet.service.adam.service.IAdamAddressesService;
import com.mysql.cj.jdbc.result.ResultSetImpl;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;

@Slf4j
@Service
public class DMAddressesProcessor extends DataMigrationProcessorService {
    @Autowired
    IAdamAddressesService adamAddressesService;

    @SneakyThrows
    @Override
    protected void dataProcessing() {
        HttpServletRequest request = ServletUtils.getRequest();
        String lS = request.getParameter(DM_LS), flg = StringUtils.defaultIfBlank(request.getParameter(DM_FLG), "");
        if (StringUtils.isNotEmpty(request.getParameter(DM_FLUSH))) {
            log.info("DM.flush.addresses:{}", userMapper.executeForDM("adam_addresses"));

            log.info("DM.flush.AdamAddressesVo:{}", mongoTemplate.remove(Query.query(Criteria.where("_id").exists(true)), AdamAddressesVo.class.getSimpleName()).getDeletedCount());
        }

        String sqlCount = "select count(1) from addresses where 1=1";
        String field = "id,user_id,user_name,user_phone,province,city,county,user_address,defaultDelivery,created_at";
//                     1-id,2-user_id,3-user_name,4-user_phone,5-province,6-city,7-county,8-user_address,9-defaultDelivery,10-created_at
        String sql = sqlCount.replace("count(1)", field);

        if ("1".equals(flg)) {
            sqlCount += " and user_id in ('2026628','544327','1997335','773650','809406','1167451','423063','677171')";
            sql += " and user_id in ('2026628','544327','1997335','773650','809406','1167451','423063','677171')";
        }

        sql += " limit ?,?";

        statement = connection.prepareStatement(sqlCount);
        row = (ResultSetImpl) statement.executeQuery();
        row.first();
        int ct = row.getInt(1), pSize = 1000, num = 0;
        log.info("DM.execute.counts:{}", ct);

        while (ct > 0) {
            statement = connection.prepareStatement(sql);
            int ls = (num == 0 && StringUtils.isNotEmpty(lS)) ? Integer.parseInt(lS) : pSize * num;
            statement.setInt(1, ls);
            statement.setInt(2, pSize);
            row = (ResultSetImpl) statement.executeQuery();
            log.info("DM.execute.limit {},{} ==> begin", ls, pSize);

            List<AdamAddresses> addressesList = new ArrayList<>();
            List<AdamAddressesVo> vos = new ArrayList<>();
            while (row.next()) {
                String uid = row.getString(2);

                if (!reUidList.contains(uid)) {
                    AdamAddresses addresses = new AdamAddresses();
                    addresses.setAddressesId(row.getString(1));
                    addresses.setUid(uid);
                    addresses.setName(row.getString(3));
                    addresses.setPhone(row.getString(4));
                    addresses.setProvince(row.getString(5));
                    addresses.setCity(row.getString(6));
                    addresses.setCounty(row.getString(7));
                    addresses.setAddress(row.getString(8));
                    addresses.setIsDefault(row.getBoolean(9));
                    addresses.setState(1);
                    addresses.setCreatedAt(row.getLocalDateTime(10));

                    AdamAddressesVo vo = AdamAddressesVo.getNew().copy(addresses);

//                    addressesMapper.insert(addresses);
//                    mongoTemplate.insert(vo, AdamAddressesVo.class.getSimpleName());
                    addressesList.add(addresses);
                    vos.add(vo);
                }
            }
            log.info("DM.execute.limit {},{} ==> handle.counts:{}", ls, pSize, addressesList.size());
            if (!CollectionUtils.isEmpty(addressesList)) {
                mongoTemplate.insert(vos, AdamAddressesVo.class.getSimpleName());
                log.info("DM.execute.result:{}", adamAddressesService.saveBatch(addressesList));
            }

            num++;
            ct -= pSize;
        }
    }
}
