package com.liquidnet.service.sweet.dto.vo.admin;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.sweet.entity.SweetIntegralActivity;
import com.liquidnet.service.sweet.entity.SweetIntegralActivityPrize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * SweetIntegralActivityVo
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-10-20
 */

@Data
@ApiModel
public class SweetIntegralActivityPrizeVo implements Serializable, Cloneable {

    private static final long serialVersionUID = 4229281062171296759L;

    @ApiModelProperty(value = "奖品id")
    private String prizeId;

    @ApiModelProperty(value = "关联活动id")
    private String integralActivityId;

    @ApiModelProperty(value = "奖品名称")
    private String prizeTitle;

    @ApiModelProperty(value = "奖品图片")
    private String prizeImg;

    @ApiModelProperty(value = "奖品类型 1谢谢惠顾 2积分 3优惠券 4实物")
    private Integer prizeType;

    @ApiModelProperty(value = "关联id 如商品id 券id")
    private String relationId;

    @ApiModelProperty(value = "奖品数量")
    private Integer prizeNum;

    @ApiModelProperty(value = "限制的中奖人数")
    private Integer winnersNum;

    @ApiModelProperty(value = "中奖概率")
    private BigDecimal winningProbability;

    @ApiModelProperty(value = "创建时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;

    @ApiModelProperty(value = "更新时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime updatedAt;

    @ApiModelProperty(value = "已发出数量")
    private Integer winPrizeNum;

    private static final SweetIntegralActivityPrizeVo obj = new SweetIntegralActivityPrizeVo();

    public static SweetIntegralActivityPrizeVo getNew() {
        try {
            return (SweetIntegralActivityPrizeVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetIntegralActivityPrizeVo();
        }
    }

    public SweetIntegralActivityPrizeVo copy(SweetIntegralActivityPrize source) {
        if (null == source) return this;
        this.setPrizeId(source.getPrizeId());
        this.setIntegralActivityId(source.getIntegralActivityId());
        this.setPrizeTitle(source.getPrizeTitle());
        this.setPrizeImg(source.getPrizeImg());
        this.setPrizeType(source.getPrizeType());
        this.setRelationId(source.getRelationId());
        this.setPrizeNum(source.getPrizeNum());
        this.setWinnersNum(source.getWinnersNum());
        this.setWinningProbability(source.getWinningProbability());
        this.setCreatedAt(source.getCreatedAt());
        this.setUpdatedAt(source.getUpdatedAt());
        return this;
    }

}
