package com.liquidnet.service.kylin.controller.partner;


import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.kylin.dto.param.TicketCreateParam;
import com.liquidnet.service.kylin.dto.vo.FieldsVo;
import com.liquidnet.service.kylin.dto.vo.TicketVo;
import com.liquidnet.service.kylin.mapper.KylinTicketsMapper;
import com.liquidnet.service.kylin.service.impl.KylinTicketsServiceImpl;
import com.liquidnet.service.kylin.service.impl.partner.FieldsPartnerServiceImpl;
import com.liquidnet.service.kylin.service.impl.partner.KylinTicketsPartnerServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 票 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-06
 */
@Api
@RestController
@RequestMapping("/partner/ticket")
public class KylinTicketsParnterController {

    @Autowired
    private KylinTicketsPartnerServiceImpl ticketsPartnerService;

    @PostMapping(value = "")
    @ApiOperation(value = "创建票务")
    @ApiResponse(response = TicketVo.class, code = 200, message = "接口返回对象参数")
    public ResponseDto<TicketVo> fieldDetails(@RequestBody TicketCreateParam ticketCreateParam) {
        TicketVo result = null;
        result = ticketsPartnerService.createTicket(ticketCreateParam);
        if (null == result) {
            return ResponseDto.failure("创建票务失败");
        } else {
            return ResponseDto.success(result);
        }
    }
}
