package com.liquidnet.service.kylin.service.impl.partner;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.kylin.dto.param.TicketCreateParam;
import com.liquidnet.service.kylin.dto.vo.TicketVo;
import com.liquidnet.service.kylin.entity.KylinFieldStatus;
import com.liquidnet.service.kylin.entity.KylinTicketRelations;
import com.liquidnet.service.kylin.entity.KylinTicketStatus;
import com.liquidnet.service.kylin.entity.KylinTickets;
import com.liquidnet.service.kylin.mapper.KylinTicketRelationsMapper;
import com.liquidnet.service.kylin.mapper.KylinTicketStatusMapper;
import com.liquidnet.service.kylin.mapper.KylinTicketsMapper;
import com.liquidnet.service.kylin.service.partner.IKylinTicketsPartnerService;
import com.mongodb.BasicDBObject;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import org.bson.Document;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;

/**
 * <p>
 * 票 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-06
 */
@Service
public class KylinTicketsPartnerServiceImpl extends ServiceImpl<KylinTicketsMapper, KylinTickets> implements IKylinTicketsPartnerService {

    @Autowired
    MongoTemplate mongoTemplate;

    @Autowired
    private MongoConverter mongoConverter;

    @Autowired
    private RedisUtil redisUtil;

    @Autowired
    private KylinTicketsMapper ticketsMapper;

    @Autowired
    private KylinTicketStatusMapper ticketStatusMapper;

    @Autowired
    private KylinTicketRelationsMapper ticketRelationsMapper;

    @Override
    public TicketVo createTicket(TicketCreateParam ticketCreateParam) {
        // 获取 主键id
        String ticketsId = IDGenerator.nextSnowId().toString();
        // 获取 当前时间 -> 创建时间
        LocalDateTime createdAt = LocalDateTime.now();

        ticketCreateParam.setTicketsId(ticketsId);

        // mysql 操作
        ticketsMapper.insert(ticketCreateParam.kylinTickets(ticketsId, createdAt));
        ticketStatusMapper.insert(ticketCreateParam.kylinTicketStatus(ticketsId, createdAt));
        ticketRelationsMapper.insert(ticketCreateParam.kylinTicketRelations(ticketsId, createdAt));

        // mongo 操作
        TicketVo ticketVo = new TicketVo();
        BeanUtils.copyProperties(ticketCreateParam, ticketVo);
        ticketVo.setTicketsId(ticketsId);
        ticketVo.setCreatedAt(createdAt.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        ticketVo.setTimeEndExpress(ticketCreateParam.getTimeEndExpress().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        ticketVo.setTimeStart(ticketCreateParam.getTimeStart().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        ticketVo.setTimeEnd(ticketCreateParam.getTimeEnd().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        ticketVo.setQrCodeShowTime(ticketCreateParam.getQrCodeShowTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        TicketVo data = mongoTemplate.insert(
                ticketVo, TicketVo.class.getSimpleName()
        );

        // redis 操作
        redisUtil.hset(KylinRedisConst.TICKET, ticketsId, ticketVo);
        return ticketVo;
    }

    @Override
    public TicketVo updateTicket(TicketCreateParam ticketCreateParam) {
        return null;
    }

    @Override
    public boolean deleteTicket(String ticketsId) {
        try {
            LocalDateTime updatedAt = LocalDateTime.now();

            KylinTicketStatus ticketStatus = new KylinTicketStatus();
            ticketStatus.setUpdatedAt(updatedAt);
            ticketStatus.setStatus(-1);
            ticketStatusMapper.update(ticketStatus
                    , new UpdateWrapper<KylinTicketStatus>().eq("ticket_id", ticketsId));

            // mongo 操作
            HashMap<String, Object> map = new HashMap<>();
            map.put("updatedAt", updatedAt.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            map.put("status", -1);

            BasicDBObject object = new BasicDBObject("$set", mongoConverter.convertToMongoType(map));
            Document doc = mongoTemplate.getCollection(TicketVo.class.getSimpleName()).findOneAndUpdate(
                    Query.query(Criteria.where("ticketsId").is(ticketsId)).getQueryObject(),
                    object,
                    new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER)
            );

            // redis 操作
            redisUtil.hset(KylinRedisConst.TICKET, ticketsId, JsonUtils.fromJson(doc.toJson(), TicketVo.class));

            return true;
        } catch (Exception e) {
            return false;
        }
    }

    @Override
    public TicketVo copyTicket(String ticketsId) {

        // 获取 当前时间 -> 创建时间
        LocalDateTime createdAt = LocalDateTime.now();

        KylinTickets tickets = ticketsMapper.selectOne(new UpdateWrapper<KylinTickets>().eq("tickets_id", ticketsId));
        tickets.setCreatedAt(createdAt);
        KylinTicketStatus ticketStatus = ticketStatusMapper.selectOne(new UpdateWrapper<KylinTicketStatus>().eq("ticket_id", ticketsId));
        ticketStatus.setCreatedAt(createdAt);
        KylinTicketRelations ticketRelations = ticketRelationsMapper.selectOne(new UpdateWrapper<KylinTicketRelations>().eq("ticket_id", ticketsId));
        ticketRelations.setCreatedAt(createdAt);

        String ticketsCopyId = IDGenerator.nextSnowId().toString();
        tickets.setTicketsId(ticketsCopyId);
        ticketStatus.setTicketId(ticketsCopyId);
        ticketStatus.setTicketStatusId(IDGenerator.nextSnowId().toString());
        ticketRelations.setTicketId(ticketsCopyId);
        ticketRelations.setTicketRelationsId(IDGenerator.nextSnowId().toString());

        ticketsMapper.insert(tickets);
        ticketStatusMapper.insert(ticketStatus);
        ticketRelationsMapper.insert(ticketRelations);

        TicketVo ticketVo = mongoTemplate.findOne(Query.query(Criteria.where("ticketsId").is(ticketsId)), TicketVo.class, TicketVo.class.getSimpleName());

        ticketVo.setTicketsId(ticketsCopyId);
        ticketVo.setCreatedAt(createdAt.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));

        TicketVo data = mongoTemplate.insert(
                ticketVo, TicketVo.class.getSimpleName()
        );

        redisUtil.hset(KylinRedisConst.TICKET, ticketsId, ticketVo);
        return ticketVo;
    }
}
