package com.liquidnet.service.goblin.service.impl;

import com.liquidnet.service.adam.constant.AdamEnum;
import com.liquidnet.service.base.ErrorMapping;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.galaxy.constant.GalaxyEnum;
import com.liquidnet.service.galaxy.dto.param.GalaxyUserRegisterReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyUserRegisterRespDto;
import com.liquidnet.service.galaxy.service.IGalaxyUserService;
import com.liquidnet.service.goblin.constant.NftAccStatusEnum;
import com.liquidnet.service.goblin.dto.GoblinUserNftAccInfoVo;
import com.liquidnet.service.goblin.service.IGoblinNftUserService;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import com.liquidnet.service.goblin.util.QueueUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDateTime;

@Slf4j
@Service
public class GoblinNftUserServiceImpl implements IGoblinNftUserService {
    @Autowired
    private QueueUtils queueUtils;
    @Autowired
    private GoblinRedisUtils goblinRedisUtils;
    @Resource(name = "galaxyUserServiceImpl")
    private IGalaxyUserService galaxyUserService;

    @Override
    public ResponseDto<GoblinUserNftAccInfoVo> openNftAccount(String uid, String bizCode, String name, String idCard, String mobile) {
        GoblinUserNftAccInfoVo openAccountInfo = goblinRedisUtils.getOpenAccountInfo(uid);
        if (null != openAccountInfo) return ResponseDto.success(openAccountInfo);
        switch (bizCode) {
            case "NFT_ZX":
                GalaxyUserRegisterReqDto userRegisterReqDto = GalaxyUserRegisterReqDto.getNew();
                userRegisterReqDto.setUserId(uid);
                userRegisterReqDto.setUserName(name);
                userRegisterReqDto.setIdCard(idCard);
                userRegisterReqDto.setMobile(mobile);
                userRegisterReqDto.setIdCardType("1");
                userRegisterReqDto.setRouterType(GalaxyEnum.RouterTypeEnum.ZXINCHAIN.getCode());

                ResponseDto<GalaxyUserRegisterRespDto> userRegisterRespDto = galaxyUserService.userRegister(userRegisterReqDto);
                if (userRegisterRespDto.isSuccess()) {
                    GoblinUserNftAccInfoVo nftAccInfoVo = GoblinUserNftAccInfoVo.getNew();
                    nftAccInfoVo.setCode(NftAccStatusEnum.StatusAcc.ING.getCode());
                    nftAccInfoVo.setMsg(NftAccStatusEnum.StatusAcc.ING.getMsg());
                    nftAccInfoVo.setTime(LocalDateTime.now());
                    goblinRedisUtils.setOpenAccountInfo(uid, nftAccInfoVo);

                    GalaxyUserRegisterRespDto userRegisterRespDtoData = userRegisterRespDto.getData();

                    queueUtils.sendMsgByRedis(MQConst.GoblinQueue.SQL_STORE.getKey(),
                            SqlMapping.get("adam_user_busi_acct.add", uid, AdamEnum.BizAcct.NFT_ZX.name(), userRegisterRespDtoData.getBlockChainAddress(), null, null, 1, LocalDateTime.now())
                    );
                    return ResponseDto.success(nftAccInfoVo);
                }
                break;
            default:
                log.warn("#开通业务账号:无效的业务码[UID={},bizCode={}]", bizCode, uid);
                break;
        }
        return ResponseDto.failure(ErrorMapping.get("140015"));
    }
}
