package com.liquidnet.service.platform.controller.adam;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.platform.service.impl.adam.PlatformMemberRefundService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

@Api(tags = "会员退款回调处理")
@Slf4j
@RestController
@RequestMapping("amorder/callack")
public class PlatformAdamMemberOrderCallbackController {
    @Autowired
    private PlatformMemberRefundService platformMemberRefundService;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "退款回调")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "status", value = "1-成功｜0-失败", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "orderCode", value = "会员订单号", example = "77062761607274496V"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "code", value = "支付订单号", example = "20210616153954199964032352974P"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "type", value = "购买类型", example = "VIP"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "price", value = "支付金额", example = "0.01"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "paymentType", value = "支付类型", example = "APPALIPAY"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "paymentAt", value = "支付时间", example = "2021-06-16 15:40:02"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "paymentId", value = "支付ID", example = "2021061622001468121421203878"),
    })
    @PostMapping("refund")
    public String refund(HttpServletRequest request) {
        log.info("/amorder/callack/refund:[mapParameter:{},token:{}]", JsonUtils.toJson(request.getParameterMap()), request.getHeader("token"));
        // TODO: 2021/6/13 验签


        if (!platformMemberRefundService.refundProcessing(request)) {
            log.warn("###会员退款回调处理失败:param:{}", JsonUtils.toJson(request.getParameterMap()));

            return "fail";
        }
        return "success";
    }
}
