package com.liquidnet.common.third.zxlnft.dto.nft;

import com.liquidnet.commons.lang.util.JsonUtils;
import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: FaceUrlReq
 * @Package com.liquidnet.common.third.zxlnft.dto.nft
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/18 15:33
 */
@Data
public class Nft018FaceUrlResp implements Serializable {
    /**
     * 启动人脸核身的h5 url
     */
    private String h5Url;
    /**
     * 人脸核验请求的唯一标识,需要保存
     */
    private String faceId;

    private static final Nft018FaceUrlResp obj = new Nft018FaceUrlResp();
    public static Nft018FaceUrlResp getNew() {
        try {
            return (Nft018FaceUrlResp) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Nft018FaceUrlResp();
        }
    }

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }
}
