package com.liquidnet.service.consumer.sweet.config;

import com.liquidnet.common.cache.redis.config.RedisStreamConfig;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.consumer.sweet.receiver.ConsumerSweetUserRdsReceiver;
import lombok.var;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

import java.util.ArrayList;
import java.util.List;

import static com.liquidnet.service.base.constant.MQConst.SweetQueue.SWEET_WECHAT_USER_INSERT;

@Configuration
public class ConsumerSweetUserRedisStreamConfig extends RedisStreamConfig {
    @Autowired
    ConsumerSweetUserRdsReceiver consumerSweetUserRdsReceiver;
    @Autowired
    StringRedisTemplate stringRedisTemplate;

    @Bean
    public List<Subscription> subscriptionSqlSWUI(RedisConnectionFactory factory) {
        List<Subscription> subscriptionList = new ArrayList<>();
        MQConst.SweetQueue stream = SWEET_WECHAT_USER_INSERT;
        this.initStream(stringRedisTemplate, stream.getKey(), stream.getGroup());
        for (int i = 0; i < 3; i++) {
            StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer = this.buildStreamMessageListenerContainer(factory);
            subscriptionList.add(listenerContainer.receiveAutoAck(
                    Consumer.from(stream.getGroup(), getConsumerName(stream.name() + i)),
                    StreamOffset.create(stream.getKey(), ReadOffset.lastConsumed()), consumerSweetUserRdsReceiver
            ));
            listenerContainer.start();
        }
        return subscriptionList;
    }
//    /**
//     * 缺票登记
//     *
//     * @param listenerContainer
//     * @param t
//     * @return
//     */
//    private Subscription receiveSqlSweetUser(StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer, int t) {
//        return listenerContainer.receiveAutoAck(Consumer.from(SWEET_WECHAT_USER_INSERT.getGroup(), getConsumerName(SWEET_WECHAT_USER_INSERT.name() + t)),
//                StreamOffset.create(SWEET_WECHAT_USER_INSERT.getKey(), ReadOffset.lastConsumed()), consumerSweetUserRdsReceiver);
//    }
//
//    /* —————————————————————————— ｜ —————————————————————————— ｜ —————————————————————————— */
//
//    /* -------------------------------------------------------- ｜ 缺票登记 */
//
//    @Bean
//    public Subscription subscriptionSqlSweetUser0(RedisConnectionFactory factory) {
//        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
//        var subscription = receiveSqlSweetUser(listenerContainer, 0);
//        listenerContainer.start();
//        return subscription;
//    }
//
//    @Bean
//    public Subscription subscriptionSqlSweetUser1(RedisConnectionFactory factory) {
//        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
//        var subscription = receiveSqlSweetUser(listenerContainer, 1);
//        listenerContainer.start();
//        return subscription;
//    }
//
//    @Bean
//    public Subscription subscriptionSqlSweetUser2(RedisConnectionFactory factory) {
//        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
//        var subscription = receiveSqlSweetUser(listenerContainer, 2);
//        listenerContainer.start();
//        return subscription;
//    }

    /* -------------------------------------------------------- ｜  */
}
