package com.liquidnet.service.goblin.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.liquidnet.service.goblin.entity.GoblinNftExActivity;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * NFT兑换活动表 Mapper 接口
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-04-19
 */
@Repository
public interface GoblinNftExActivityMapper extends BaseMapper<GoblinNftExActivity> {


    /**
     * 添加ntf兑换活动数据
     * @param goblinNftExActivity
     * @return
     */
    int addGoblinNftExActivity(GoblinNftExActivity goblinNftExActivity);

    /**
     * 分页回去nft兑换活动数据
     * @param title
     * @param startTime
     * @param endTime
     * @return
     */
    List<GoblinNftExActivity> selectPageList(@Param("title") String title, @Param("startTime") LocalDateTime startTime,@Param("endTime") LocalDateTime endTime);

    /**
     * 根据活动ids 获取活动
     * @param activityId
     * @return
     */
    GoblinNftExActivity selectByActivityId(@Param("activityId") String activityId);
}
