/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.toplink.embedded.websocket.frame.rfc6455;

import com.taobao.api.internal.toplink.embedded.websocket.frame.rfc6455.FrameBuilderRfc6455;
import com.taobao.api.internal.toplink.embedded.websocket.frame.rfc6455.FrameHeaderRfc6455;
import com.taobao.api.internal.toplink.embedded.websocket.frame.rfc6455.FrameRfc6455;
import java.io.UnsupportedEncodingException;

public class TextFrame
extends FrameRfc6455 {
    private String convertedString;

    public TextFrame(FrameHeaderRfc6455 header, byte[] bodyData) {
        super(header, bodyData);
    }

    public TextFrame(String str) {
        byte[] body = TextFrame.convertStringToByteArray(str);
        this.setHeader(FrameBuilderRfc6455.createFrameHeader(body, false, FrameBuilderRfc6455.Opcode.TEXT_FRAME));
        this.setContents(body);
    }

    private static byte[] convertStringToByteArray(String str) {
        try {
            return str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public String toString() {
        if (this.convertedString == null) {
            try {
                this.convertedString = new String(this.contents, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.convertedString = "";
            }
        }
        return this.convertedString;
    }
}

