package com.liquidnet.client.admin.zhengzai.goblin.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.zhengzai.goblin.service.IGoblinFrontSelectGoodsService;
import com.liquidnet.common.cache.redis.util.RedisGoblinUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.goblin.constant.GoblinRedisConst;
import com.liquidnet.service.goblin.entity.GoblinFrontSelectGoods;
import com.liquidnet.service.goblin.entity.GoblinGoods;
import com.liquidnet.service.goblin.mapper.GoblinFrontSelectGoodsMapper;
import com.liquidnet.service.goblin.mapper.GoblinGoodsMapper;
import com.liquidnet.service.goblin.param.GoblinFrontSelectGoodsParam;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 精选商品
 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2022-01-04
 */
@Service
public class GoblinFrontSelectGoodsServiceImpl extends ServiceImpl<GoblinFrontSelectGoodsMapper, GoblinFrontSelectGoods> implements IGoblinFrontSelectGoodsService {

    //private GoblinGoodsMapper goblinGoodsMapper;
    @Autowired
    private GoblinFrontSelectGoodsMapper goblinFrontSelectGoodsMapper;
    @Autowired
    private RedisGoblinUtil redisGoblinUtil;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    GoblinGoodsMapper goblinGoodsMapper;

    public boolean create(GoblinFrontSelectGoods goblinFrontSelectGoods){
        List list= this.getList();
        if(list.size()>0){
            return false;
        }
        //
        goblinFrontSelectGoods.setCreateTime(LocalDateTime.now());
        goblinFrontSelectGoods.setUpdateTime(LocalDateTime.now());
        //设置bannerid
        goblinFrontSelectGoods.setSelectGoodsId(IDGenerator.nextSnowId());
        //增加 banner
        //goblinFrontSeckillMapper.insert(goblinFrontSeckill);
        goblinFrontSelectGoodsMapper.insert(goblinFrontSelectGoods);
        return true;
    }
    public GoblinFrontSelectGoods getOne(Long id){
        return  goblinFrontSelectGoodsMapper.selectById(id);
    }

    public boolean delte(Long id){
        GoblinFrontSelectGoods goblinFrontSelectGoods=goblinFrontSelectGoodsMapper.selectById(id);
        goblinFrontSelectGoods.setDelTag(1);
        this.update(goblinFrontSelectGoods);
        return true;
    }

    public boolean update(GoblinFrontSelectGoods goblinFrontSelectGoods){
        //清空精选商品
        goblinFrontSelectGoodsMapper.deleteAll();
        //重新创建
        String spuIds=goblinFrontSelectGoods.getSpuId();
        if(StringUtil.isNotBlank(spuIds)){
            String[] spuIdss=spuIds.split(",");
            int index=0;
            for(String spuId:spuIdss){
                index++;
                GoblinFrontSelectGoods goblinFrontSelectGoods1=new GoblinFrontSelectGoods();
                goblinFrontSelectGoods1.setIndexs(index);
                goblinFrontSelectGoods1.setUpdateTime(LocalDateTime.now());
                goblinFrontSelectGoods1.setDelTag(0);
                goblinFrontSelectGoods1.setCreateTime(LocalDateTime.now());
                goblinFrontSelectGoods1.setSelectGoodsId(IDGenerator.nextSnowId());
                goblinFrontSelectGoods1.setSpuId(spuId);
                goblinFrontSelectGoods1.setOrderType(goblinFrontSelectGoods.getOrderType());
                goblinFrontSelectGoodsMapper.insert(goblinFrontSelectGoods1);
            }
        }else{
            GoblinFrontSelectGoods goblinFrontSelectGoods1=new GoblinFrontSelectGoods();
            goblinFrontSelectGoods1.setUpdateTime(LocalDateTime.now());
            goblinFrontSelectGoods1.setDelTag(0);
            goblinFrontSelectGoods1.setCreateTime(LocalDateTime.now());
            goblinFrontSelectGoods1.setSelectGoodsId(IDGenerator.nextSnowId());
            goblinFrontSelectGoods1.setOrderType(goblinFrontSelectGoods.getOrderType());
            goblinFrontSelectGoodsMapper.insert(goblinFrontSelectGoods1);
        }
      /*  if(goblinFrontSelectGoods.getMid()>0){
            goblinFrontSelectGoods.setUpdateTime(LocalDateTime.now());
            goblinFrontSelectGoodsMapper.updateById(goblinFrontSelectGoods);
        }else{
            this.create(goblinFrontSelectGoods);
        }*/
        return true;
    }

   public  List getList(){
       LambdaQueryWrapper<GoblinFrontSelectGoods> queryWrapper = Wrappers.lambdaQuery(GoblinFrontSelectGoods.class);
       queryWrapper.eq(GoblinFrontSelectGoods::getDelTag,0);
       queryWrapper.orderByAsc(GoblinFrontSelectGoods::getIndexs);
       List<GoblinFrontSelectGoods> list= goblinFrontSelectGoodsMapper.selectList(queryWrapper);
       String spuIds="";
       for(GoblinFrontSelectGoods goblinFrontSelectGoods:list){
           if(StringUtil.isBlank(spuIds)){
               spuIds=goblinFrontSelectGoods.getSpuId();
           }else{
               spuIds=spuIds+","+goblinFrontSelectGoods.getSpuId();
           }
       }
       if(list.size()>0){
           GoblinFrontSelectGoods p=list.get(0);
           GoblinFrontSelectGoods a=new GoblinFrontSelectGoods();
           a.setOrderType(p.getOrderType());
           a.setSelectGoodsId(spuIds);
           a.setCreateTime(p.getCreateTime());
           a.setDelTag(p.getDelTag());
           a.setUpdateTime(p.getUpdateTime());
           a.setSpuId(spuIds);
           a.setSelectGoodsId("1");
           a.setMid(1l);
           List<GoblinGoods> goblinGoodsList =new ArrayList<>();
           List<GoblinFrontSelectGoodsParam> goodsP =new ArrayList<>();
           if(StringUtil.isNotBlank(spuIds)){
               String[] dd=spuIds.split(",");
               for(String id:dd){
                   LambdaQueryWrapper<GoblinGoods> queryWrappers = Wrappers.lambdaQuery(GoblinGoods.class);
                   queryWrappers.ne(GoblinGoods::getDelFlg,"1");
                   queryWrappers.eq(GoblinGoods::getSpuId,id);
                   List<GoblinGoods> goodsList= goblinGoodsMapper.selectList(queryWrappers);
                   if(goodsList.size()>0){
                       goblinGoodsList.add(goodsList.get(0));
                   }
               }
               GoblinFrontSelectGoodsParam goblinFrontSelectGoodsParam=new GoblinFrontSelectGoodsParam();
               BeanUtils.copyProperties(a,goblinFrontSelectGoodsParam);
               goblinFrontSelectGoodsParam.setGoblinGoodsList(goblinGoodsList);
               goodsP.add(goblinFrontSelectGoodsParam);
               return goodsP;
           }else{
               GoblinFrontSelectGoodsParam goblinFrontSelectGoodsParam=new GoblinFrontSelectGoodsParam();
               BeanUtils.copyProperties(a,goblinFrontSelectGoodsParam);
               goblinFrontSelectGoodsParam.setGoblinGoodsList(goblinGoodsList);
               goodsP.add(goblinFrontSelectGoodsParam);
               return goodsP;
           }
       }else{
           return null;
       }
   }
    public boolean online(){
      //查询
        LambdaQueryWrapper<GoblinFrontSelectGoods> queryWrapper = Wrappers.lambdaQuery(GoblinFrontSelectGoods.class);
        queryWrapper.eq(GoblinFrontSelectGoods::getDelTag,0);
        queryWrapper.orderByAsc(GoblinFrontSelectGoods::getIndexs);
        List<GoblinFrontSelectGoods> list=goblinFrontSelectGoodsMapper.selectList(queryWrapper);
        //删除  mogndob
        Query query = Query.query(Criteria.where("delTag").is("0"));
        mongoTemplate.findAllAndRemove(query, GoblinFrontSelectGoods.class);
        int sortType=0;
        if(list.size()>0){
            for(GoblinFrontSelectGoods goblinFrontSelectGoods:list){
                sortType=goblinFrontSelectGoods.getOrderType();
                mongoTemplate.save(goblinFrontSelectGoods,GoblinFrontSelectGoods.class.getSimpleName());
            }
            redisGoblinUtil.set(GoblinRedisConst.SELECT_GOODS_SORT,sortType);
            redisGoblinUtil.set(GoblinRedisConst.SELECT_GOODS,list);
            redisGoblinUtil.del(GoblinRedisConst.SELECT_GOODS_SPUIDS);
            redisGoblinUtil.del(GoblinRedisConst.SELECT_GOODS_PAGE1);
            redisGoblinUtil.del(GoblinRedisConst.SELECT_GOODS_SPUIDS_ISHAVE);
        }

        return  true;
    }
}
