/**
 * $Id: NameUtil.java 149 2012-09-15 09:17:48Z rex.zhao $
 * Copyright(C) 2012-2016 zlz organization, All Rights Reserved.
 */
package com.liquidnet.commons.lang.util;

/**
 * 名称转化工具类
 * @author <a href="kowlone2006@163.com">kowlone</a>
 * @version 1.0 2012-4-27 下午9:56:27
 */
public abstract class NameUtil {

	/**
	 * 根据类全路径名称取得类描述符名称
	 * <pre>
	 *     例：
	 *     ("NameUtil") -> "com/nature/commons/lang/util/NameUtil"
	 * </pre>
	 * @param className 类全路径名称
	 * @return 类描述符名称
	 */
	public static String className2ClassDescriptor(String className) {
		return className.replaceAll("\\.", "/");
	}

	/**
	 * 将属性名称转化为指定前缀的方法名称
	 * <pre>
	 *     例：
	 *     ("fieldName", "set") -> "setFieldName"
	 *     ("fieldName", "get") -> "getFieldName"
	 * </pre>
	 * @param fieldName 属性名称
	 * @param methodNameHeader 方法名称前缀
	 * @return 方法名称
	 */
	public static String fieldName2MethodName(String fieldName, String methodNameHeader) {
		return methodNameHeader + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
	}

	/**
	 * 将指定的字符串按照分隔符替换为Java包路径
	 * @param str 待替换字符串
	 * @param split 分隔符
	 * @return 替换后的Java包路径
	 */
	public static String $2PackageName(String str, char split) {
		int length = str.length();
		StringBuilder ret = new StringBuilder(length);

		for (int i = 0; i < length; i++) {
			char ch = str.charAt(i);
			if (ch == split) {
				ret.append(".");
			} else {
				ret.append(ch);
			}
		}

		return ret.toString();
	}

	/**
	 * 将指定的字符串按照分隔符替换为Java类名称
	 * @param str 待替换字符串
	 * @param split 分隔符
	 * @return 替换后的Java类名称
	 */
	public static String $2ClassName(String str, char split) {
		int length = str.length();
		StringBuilder ret = new StringBuilder(length);

		boolean capitalFlg = true;
		for (int i = 0; i < length; i++) {
			char ch = str.charAt(i);
			if (capitalFlg) {
				ret.append(Character.toUpperCase(ch));
				capitalFlg = false;
			} else if (ch == split) {
				capitalFlg = true;
			} else {
				ret.append(ch);
			}
		}

		return ret.toString();
	}


	public static String toDbFormate(String source) {
		StringBuilder sb = new StringBuilder();
		for (int i = 0; i < source.length(); i++) {
			char c = source.charAt(i);
			if (c >= 65 && c <= 90) {
				if (i != 0) {
                    sb.append("_");
                }
				sb.append((char)(c + 32));
			} else {
				sb.append(c);
			}
		}
		return sb.toString();
	}


	public static String toJavaFormate(String source) {
		StringBuilder sb = new StringBuilder();

		for (int i = 0; i < source.length(); i++) {
			char c = source.charAt(i);
			if (c == 95) {//如果是下划线
				sb.append(Character.toUpperCase(source.charAt(++i)));
			}else {
				sb.append(c);
			}
		}
		return sb.toString();
	}

}
