package com.liquidnet.service.adam.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 会员价格
 */
@ApiModel(value = "AdamMemberPriceVo", description = "会员价格")
@Data
public class AdamMemberPriceVo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 会员价格ID
     */
    @ApiModelProperty(position = 1, value = "会员价格id")
    private String memberPriceId;

    /**
     * 会员类型ID
     */
    @ApiModelProperty(position = 2, value = "会员类型id")
    private String memberId;

    /**
     * 状态  0 不可用 1上线中 2已下线
     */
    @ApiModelProperty(position = 3, value = "价格状态")
    private Integer status;

    /**
     * 价格包名称
     */
    @ApiModelProperty(position = 4, value = "价格包名称")
    private String name;

    /**
     * 原价
     */
    @ApiModelProperty(position = 5, value = "原价")
    private BigDecimal price;

    /**
     * 折扣价
     */
    @ApiModelProperty(position = 6, value = "折扣价")
    private BigDecimal priceFixed;

    /**
     * 会员包有效天数
     */
    @ApiModelProperty(position = 7, value = "有效天数")
    private Integer days;

    /**
     * 会员包须知
     */
    @ApiModelProperty(position = 8, value = "须知")
    private String detail;

    /**
     * 创建时间
     */
    @ApiModelProperty(position = 9, value = "创建时间")
    private String createdAt;

    /**
     * 更新时间
     */
    @ApiModelProperty(position = 10, value = "更新时间")
    private String updatedAt;
}
