package com.liquidnet.service.bank.currencycloud.service.impl;

import com.currencycloud.client.CurrencyCloudClient;
import com.currencycloud.client.exception.ApiException;
import com.currencycloud.client.model.Payer;
import com.currencycloud.client.model.Payment;
import com.liquidnet.common.exception.constant.ErrorCode;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.bank.currencycloud.entity.BankCcPayer;
import com.liquidnet.service.bank.currencycloud.entity.BankCcPayment;
import com.liquidnet.service.bank.currencycloud.mapper.BankCcPayerMapper;
import com.liquidnet.service.bank.currencycloud.mapper.BankCcPaymentMapper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import java.math.BigDecimal;

import static org.junit.Assert.*;

@Slf4j
@SpringBootTest
@RunWith(SpringRunner.class)
public class BankCcPaymentServiceImplTest {

    @Autowired
    private CurrencyCloudClient currencyCloudClient;

    @Autowired
    private BankCcPaymentMapper bankCcPaymentMapper;

    @Autowired
    private BankCcPayerMapper bankCcPayerMapper;

    @Test
    public void createPayment() {
        try {
//            Payment payment = currencyCloudClient.createPayment(getPayment(), null);
//            log.info(JsonUtils.toJson(payment));
//            BankCcPayment bankCcPayment = new BankCcPayment();
//            BeanUtils.copyProperties(payment, bankCcPayment);
//            bankCcPaymentMapper.insert(bankCcPayment);
            Payer payer = currencyCloudClient.retrievePayer("0e9626be-6c11-47e5-87ae-dcd3df9b99f9");
            log.info(JsonUtils.toJson(payer));
        } catch (ApiException e) {
            int statusCode = e.getResponse().statusCode;
            log.info(JsonUtils.toJson(e));
        }

    }

    private Payment getPayment() {
        Payment payment = Payment.create();
        payment.setCurrency("GBP");
        payment.setBeneficiaryId("98df3714-49d0-439c-ab02-a8d194cf4e58");
        payment.setAmount(new BigDecimal(10));
        payment.setReason("test");
        payment.setReference("test");
        payment.setPaymentType("regular");
        return payment;
    }

    private Payer buildPayer() {
        Payer payer = Payer.create();

        return payer;
    }
}
