package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@ApiModel(value = "GoblinDigitalArtworkListVo", description = "藏品列表信息")
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinUserDigitalArtworkListVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -1510553574954846520L;
    @ApiModelProperty(position = 11, value = "藏品Id")
    private String artworkId;

    @ApiModelProperty(position = 12, value = "藏品名称")
    private String name;
    @ApiModelProperty(position = 13, value = "藏品副名称")
    private String subtitle;
    @ApiModelProperty(position = 14, value = "藏品封面")
    private String coverPic;
    @ApiModelProperty(position = 15, value = "序列号")
    private Integer editionSn;
    @ApiModelProperty(position = 16, value = "藏品发行量")
    private Integer edition;
    @ApiModelProperty(position = 17, value = "获得方式[1-购买|2-兑换|3-赠送|5-受赠]")
    private Integer source;

    @ApiModelProperty(position = 18, value = "藏品状态，根据`unbox`区分盲盒来判断[0-生成中/未开启|1-已生成/已开启|2-生成失败/开启失败]")
    private Integer state;
    @ApiModelProperty(position = 19, value = "藏品创建时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;


    @ApiModelProperty(position = 20, value = "是否盲盒[0-否|1-是]")
    private String unbox;
    @ApiModelProperty(position = 21, value = "盲盒开启时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime openingTime;

    @ApiModelProperty(position = 22, value = "创作者")
    private String author;


    private static final GoblinUserDigitalArtworkListVo obj = new GoblinUserDigitalArtworkListVo();

    public static GoblinUserDigitalArtworkListVo getNew() {
        try {
            return (GoblinUserDigitalArtworkListVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinUserDigitalArtworkListVo();
        }
    }

    public GoblinUserDigitalArtworkListVo copy(GoblinUserDigitalArtworkVo source) {
        this.setArtworkId(source.getArtworkId());
//        this.setName();
//        this.setSubtitle();
//        this.setCoverPic();
//        this.setEdition();
        this.setEditionSn(source.getEditionSn());
        this.setSource(source.getSource());
        this.setState(source.getState());
        this.setCreatedAt(source.getCreatedAt());
//        this.setUnbox();
//        this.setOpeningTime();

        this.setAuthor(source.getAuthor());
        return this;
    }
}
